/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.action.impl;

import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.action.Action;
import net.bitbylogic.structures.lib.bitsutils.action.ConfiguredMetadataActionData;
import net.bitbylogic.structures.lib.bitsutils.action.data.ActionData;
import net.bitbylogic.structures.lib.bitsutils.action.data.StringActionData;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.context.DefaultContextKeys;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class BroadcastSoundAction
implements Action {
    private static final float DEFAULT_VOLUME = 1.0f;
    private static final float DEFAULT_PITCH = 1.0f;

    @Override
    public String getId() {
        return "broadcast_sound";
    }

    @Override
    public boolean execute(@NonNull Context context) {
        Sound sound;
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ActionData actionData = context.get(DefaultContextKeys.ACTION_DATA).orElse(null);
        if (actionData == null) {
            return false;
        }
        String soundName = "";
        float volume = 1.0f;
        float pitch = 1.0f;
        if (actionData instanceof ConfiguredMetadataActionData) {
            ConfiguredMetadataActionData metaData = (ConfiguredMetadataActionData)actionData;
            soundName = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Sound", "");
            volume = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Volume", Float.valueOf(1.0f)).floatValue();
            pitch = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Pitch", Float.valueOf(1.0f)).floatValue();
        } else if (actionData instanceof StringActionData) {
            StringActionData stringData = (StringActionData)actionData;
            String[] parts = ((String)stringData.getData()).split(":");
            if (parts.length >= 1) {
                soundName = parts[0].toUpperCase();
            }
            if (parts.length >= 2) {
                volume = this.parseFloat(parts[1]);
            }
            if (parts.length >= 3) {
                pitch = this.parseFloat(parts[2]);
            }
        } else {
            return false;
        }
        try {
            sound = Sound.valueOf((String)soundName);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        return true;
    }

    private float parseFloat(String str) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    @Override
    public boolean canExecute(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return true;
    }

    @Generated
    public BroadcastSoundAction() {
    }
}

