/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.action.impl;

import lombok.Generated;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.action.Action;
import net.bitbylogic.structures.lib.bitsutils.action.ConfiguredMetadataActionData;
import net.bitbylogic.structures.lib.bitsutils.action.data.ActionData;
import net.bitbylogic.structures.lib.bitsutils.action.data.StringActionData;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.structures.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.context.DefaultContextKeys;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import org.bukkit.entity.Player;

public class PlayerMessageAction
implements Action {
    @Override
    public String getId() {
        return "player_message";
    }

    @Override
    public boolean execute(@NonNull Context context) {
        String message;
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
        if (player == null) {
            return false;
        }
        ActionData actionData = context.get(DefaultContextKeys.ACTION_DATA).orElse(null);
        if (actionData == null) {
            return false;
        }
        if (actionData instanceof ConfiguredMetadataActionData) {
            ConfiguredMetadataActionData metaData = (ConfiguredMetadataActionData)actionData;
            message = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Message", "");
        } else if (actionData instanceof StringActionData) {
            StringActionData stringData = (StringActionData)actionData;
            message = (String)stringData.getData();
        } else {
            return false;
        }
        String finalMessage = Formatter.format(PlaceholderAPI.setPlaceholders((Player)player, (String)message.replace("%player%", player.getName())), new StringModifier[0]);
        player.sendMessage(finalMessage);
        return true;
    }

    @Override
    public boolean canExecute(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.has(BukkitContextKeys.PLAYER);
    }

    @Generated
    public PlayerMessageAction() {
    }
}

