/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.condition.Condition;
import net.bitbylogic.structures.lib.bitsutils.condition.type.impl.HasPermissionCondition;

public final class ConditionRegistry {
    private static final Map<String, Condition> CONDITIONS = new HashMap<String, Condition>();

    private ConditionRegistry() {
    }

    public static void register(@NonNull Condition condition) {
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        CONDITIONS.putIfAbsent(condition.getId().toLowerCase(), condition);
    }

    public static void unregister(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        CONDITIONS.remove(id.toLowerCase());
    }

    public static Optional<Condition> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable(CONDITIONS.get(id.toLowerCase()));
    }

    public static Set<String> getIds() {
        return CONDITIONS.keySet();
    }

    public static boolean contains(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return CONDITIONS.containsKey(id.toLowerCase());
    }

    public static void clear() {
        CONDITIONS.clear();
    }

    static {
        ConditionRegistry.register(new HasPermissionCondition());
    }
}

