/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.condition.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.condition.reference.ConditionReference;
import net.bitbylogic.structures.lib.bitsutils.reference.ObjectReference;

public final class ConditionReferenceRegistry {
    private static final Map<String, ConditionReference> REFERENCES = new HashMap<String, ConditionReference>();

    private ConditionReferenceRegistry() {
    }

    static void track(@NonNull ConditionReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        REFERENCES.put((String)reference.getId(), reference);
    }

    public static ConditionReference getCondition(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return REFERENCES.get(id);
    }

    public static void untrack(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        REFERENCES.remove(id);
    }

    public static void clear() {
        REFERENCES.clear();
    }

    public static void invalidateAll() {
        REFERENCES.values().forEach(ObjectReference::invalidateCache);
    }

    public static Map<String, ConditionReference> all() {
        return Collections.unmodifiableMap(REFERENCES);
    }
}

