/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.condition.type.impl;

import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.condition.type.SimpleCondition;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.structures.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HasPermissionCondition
extends SimpleCondition {
    private static final String FALLBACK_PERMISSION = "bukkit.command.reload";

    @Override
    @NonNull
    public String getId() {
        return "player_has_permission";
    }

    @Override
    public boolean matches(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
        ConfiguredMetadata metadata = context.get(BukkitContextKeys.CONFIGURED_METADATA).orElse(null);
        if (player == null || metadata == null || !metadata.hasKey("Permission")) {
            return false;
        }
        return player.hasPermission(metadata.getValueAsOrDefault("Permission", FALLBACK_PERMISSION));
    }

    @Override
    @NonNull
    @NotNull
    public String getErrorMessage(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return "";
    }
}

