/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.config.configurable;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.Pair;
import net.bitbylogic.structures.lib.bitsutils.config.configurable.data.ConfigKeyData;
import net.bitbylogic.structures.lib.bitsutils.config.configurable.wrapper.ConfigWrapper;
import net.bitbylogic.structures.lib.bitsutils.config.configurable.wrapper.impl.DefaultConfigWrapper;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configurable {
    private final DefaultConfigWrapper DEFAULT_WRAPPER = new DefaultConfigWrapper();
    private final HashMap<ConfigKeyData, Object> configValues = new HashMap();
    private final HashMap<String, ConfigWrapper<?>> valueWrappers = new HashMap();
    private final boolean saveDefaults;
    private File configFile;
    private String globalPrefix;

    public Configurable(@NonNull File configFile, @NonNull String globalPrefix, Pair<Object, Object> ... defaultValues) {
        this(configFile, true, globalPrefix, defaultValues);
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (globalPrefix == null) {
            throw new NullPointerException("globalPrefix is marked non-null but is null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("defaultValues is marked non-null but is null");
        }
    }

    public Configurable(@NonNull File configFile, boolean saveDefaults, @NonNull String globalPrefix, Pair<Object, Object> ... defaultValues) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (globalPrefix == null) {
            throw new NullPointerException("globalPrefix is marked non-null but is null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("defaultValues is marked non-null but is null");
        }
        this.configFile = configFile;
        this.globalPrefix = globalPrefix;
        this.saveDefaults = saveDefaults;
        for (Pair<Object, Object> defaultValue : defaultValues) {
            Object key = defaultValue.getKey();
            Object value = defaultValue.getValue();
            ConfigKeyData configKeyData = key instanceof ConfigKeyData ? (ConfigKeyData)key : ConfigKeyData.of(key.toString());
            this.configValues.put(configKeyData, value);
        }
        this.loadConfigPaths();
    }

    public Configurable(@NonNull File configFile, @NonNull String globalPrefix) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (globalPrefix == null) {
            throw new NullPointerException("globalPrefix is marked non-null but is null");
        }
        this.configFile = configFile;
        this.globalPrefix = globalPrefix;
        this.saveDefaults = true;
        this.loadConfigPaths();
    }

    public Configurable(@NonNull File configFile, Pair<Object, Object> ... defaultValues) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("defaultValues is marked non-null but is null");
        }
        this.configFile = configFile;
        this.saveDefaults = true;
        for (Pair<Object, Object> defaultValue : defaultValues) {
            Object key = defaultValue.getKey();
            Object value = defaultValue.getValue();
            ConfigKeyData configKeyData = key instanceof ConfigKeyData ? (ConfigKeyData)key : ConfigKeyData.of(key.toString());
            this.configValues.put(configKeyData, value);
        }
        this.loadConfigPaths();
    }

    public Configurable(@NonNull File configFile) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        this.configFile = configFile;
        this.saveDefaults = true;
        this.loadConfigPaths();
    }

    public Configurable() {
        this.configFile = null;
        this.saveDefaults = true;
        this.loadConfigPaths();
    }

    protected static Pair<Object, Object> pair(Object key, Object value) {
        return new Pair<Object, Object>(key, value);
    }

    public void addConfigValue(@NonNull Object key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ConfigKeyData configKeyData = key instanceof ConfigKeyData ? (ConfigKeyData)key : ConfigKeyData.of(key.toString());
        this.configValues.put(configKeyData, value);
    }

    public void loadConfigPaths() {
        if (this.configFile == null || this.configValues.isEmpty()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.configValues.forEach((arg_0, arg_1) -> this.lambda$loadConfigPaths$0((FileConfiguration)config, arg_0, arg_1));
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveToConfig() {
        if (!this.saveDefaults || this.configFile == null || this.configValues.isEmpty()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.configValues.forEach((arg_0, arg_1) -> this.lambda$saveToConfig$1((FileConfiguration)config, arg_0, arg_1));
    }

    public boolean hasConfigValue(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.configValues.entrySet().stream().anyMatch(entry -> ((ConfigKeyData)entry.getKey()).getPath().equalsIgnoreCase(path));
    }

    public <T> T getConfigValue(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.configValues.entrySet().stream().filter(entry -> ((ConfigKeyData)entry.getKey()).getPath().equalsIgnoreCase(path)).map(entry -> entry.getValue()).findFirst().orElse(null);
    }

    public <T> T getConfigValueOrDefault(@NonNull String path, @NonNull T defaultValue) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return this.getConfigValueOrDefault(path, defaultValue, true);
    }

    public <T> T getConfigValueOrDefault(@NonNull String path, @NonNull T defaultValue, boolean save) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.configFile == null) {
            return defaultValue;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.hasConfigValue(path)) {
            try {
                return this.getConfigValue(path);
            }
            catch (ClassCastException e) {
                Bukkit.getLogger().log(Level.SEVERE, "Unable to cast config value");
                e.printStackTrace();
                return defaultValue;
            }
        }
        Object actualValue = config.get(path);
        if (actualValue == null && save && this.saveDefaults) {
            String finalPath = this.globalPrefix == null ? path : this.globalPrefix + path;
            config.set(finalPath, defaultValue);
            this.configValues.put(ConfigKeyData.of(finalPath, ""), defaultValue);
            this.saveConfig();
        }
        try {
            return (T)(actualValue == null ? defaultValue : actualValue);
        }
        catch (ClassCastException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Unable to cast config value");
            e.printStackTrace();
            return defaultValue;
        }
    }

    private void saveConfig() {
        if (this.configFile == null) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        try {
            config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerWrapper(String id, ConfigWrapper wrapper) {
        this.valueWrappers.put(id, wrapper);
    }

    @Generated
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @Generated
    public void setGlobalPrefix(String globalPrefix) {
        this.globalPrefix = globalPrefix;
    }

    private /* synthetic */ void lambda$saveToConfig$1(FileConfiguration config, ConfigKeyData data, Object object) {
        DefaultConfigWrapper wrapper;
        String path = data.getPath();
        String wrapperId = data.getWrapperId();
        String finalPath = this.globalPrefix == null ? path : this.globalPrefix + path;
        ConfigWrapper<Object> configWrapper = wrapper = wrapperId.isEmpty() ? this.DEFAULT_WRAPPER : (ConfigWrapper)this.valueWrappers.getOrDefault(wrapperId, this.DEFAULT_WRAPPER);
        if (config.isSet(finalPath)) {
            return;
        }
        if (wrapper == null) {
            config.set(finalPath, object);
            return;
        }
        wrapper.wrap(object, finalPath, config);
    }

    private /* synthetic */ void lambda$loadConfigPaths$0(FileConfiguration config, ConfigKeyData data, Object object) {
        DefaultConfigWrapper wrapper;
        String path = data.getPath();
        String wrapperId = data.getWrapperId();
        String finalPath = this.globalPrefix == null ? path : this.globalPrefix + path;
        ConfigWrapper<Object> configWrapper = wrapper = wrapperId.isEmpty() ? this.DEFAULT_WRAPPER : (ConfigWrapper)this.valueWrappers.getOrDefault(wrapperId, this.DEFAULT_WRAPPER);
        if (!config.isSet(finalPath)) {
            if (!this.saveDefaults) {
                return;
            }
            if (wrapper == null) {
                config.set(finalPath, object);
                return;
            }
            wrapper.wrap(object, finalPath, config);
            return;
        }
        Object configValue = config.get(finalPath);
        if (configValue == null) {
            return;
        }
        this.configValues.put(data, wrapper == null ? configValue : wrapper.unwrap(configValue, object.getClass()));
    }
}

