/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.config.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class ConfigurableMetadata
extends ConfiguredMetadata {
    private final Map<String, Object> pendingDefaults = new LinkedHashMap<String, Object>();
    @Nullable
    private File configFile;

    public ConfigurableMetadata() {
        this.configFile = null;
    }

    public ConfigurableMetadata(@Nullable File configFile, @Nullable ConfigurationSection section, Map<String, Object> defaults) {
        super(section);
        this.configFile = configFile;
        if (section == null) {
            return;
        }
        boolean changed = false;
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (section.contains(key)) continue;
            this.setValue(key, value, false);
            changed = true;
        }
        if (!changed || configFile == null) {
            return;
        }
        this.saveToFile();
    }

    public ConfigurableMetadata withDefault(String key, Object value) {
        this.pendingDefaults.put(key, value);
        if (this.getSection() != null) {
            if (this.getSection().isSet(key)) {
                this.pendingDefaults.remove(key);
                return this;
            }
            this.setValue(key, value, true);
            this.pendingDefaults.remove(key);
        }
        return this;
    }

    private Object convertForConfig(Object value) {
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                return new ArrayList();
            }
            if (!(set.iterator().next() instanceof Enum)) {
                return List.of(set.stream().map(Object::toString).toList());
            }
            return set.stream().map(e -> ((Enum)e).name()).toList();
        }
        return value;
    }

    public <T> T getValueAsOrDefault(@NonNull String key, T defaultValue, boolean save) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String loweredKey = key.toLowerCase();
        T value = this.getMetadataMap().getValueAsOrDefault(loweredKey, null);
        if (value != null) {
            return value;
        }
        this.setValue(key, defaultValue, save);
        return defaultValue;
    }

    public <T> T getDeepValueAsOrDefault(@NonNull String key, T defaultValue, boolean save) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String loweredKey = key.toLowerCase();
        T value = this.getMetadataDeepMap().getValueAsOrDefault(loweredKey, null);
        if (value != null) {
            return value;
        }
        this.setValue(key, defaultValue, save);
        return defaultValue;
    }

    public <T> void setValue(String key, @Nullable T value, boolean save) {
        if (this.getSection() == null) {
            throw new IllegalStateException("Cannot set value without a configuration section");
        }
        String loweredKey = key.toLowerCase();
        this.getMetadataMap().put(loweredKey, value);
        this.getMetadataDeepMap().put(loweredKey, value);
        this.getSection().set(key, this.convertForConfig(value));
        if (!save || this.configFile == null) {
            return;
        }
        this.saveToFile();
    }

    public void removeValue(String key, boolean save) {
        if (this.getSection() == null) {
            throw new IllegalStateException("Cannot remove value without a configuration section");
        }
        String loweredKey = key.toLowerCase();
        this.getMetadataMap().remove(loweredKey);
        this.getMetadataDeepMap().remove(loweredKey);
        this.getSection().set(key, null);
        if (!save || this.configFile == null) {
            return;
        }
        this.saveToFile();
    }

    public void load(@NonNull File configFile) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (!configFile.getName().endsWith(".yml")) {
            throw new IllegalArgumentException("File must be a YAML file");
        }
        this.configFile = configFile;
        configFile.getParentFile().mkdirs();
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("Failed to create configuration file " + String.valueOf(configFile));
            }
        }
        super.load((ConfigurationSection)YamlConfiguration.loadConfiguration((File)configFile));
        for (Map.Entry<String, Object> entry : this.pendingDefaults.entrySet()) {
            if (this.getSection() != null && this.getSection().isSet(entry.getKey())) continue;
            this.setValue(entry.getKey(), entry.getValue(), true);
        }
        this.pendingDefaults.clear();
    }

    public void load(@NonNull File configFile, @NonNull ConfigurationSection section) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (!configFile.getName().endsWith(".yml")) {
            throw new IllegalArgumentException("File must be a YAML file");
        }
        this.configFile = configFile;
        super.load(section);
        for (Map.Entry<String, Object> entry : this.pendingDefaults.entrySet()) {
            if (section.isSet(entry.getKey())) continue;
            this.setValue(entry.getKey(), entry.getValue(), true);
        }
        this.pendingDefaults.clear();
    }

    public void reloadFromFile() {
        YamlConfiguration sectionToLoad;
        if (this.configFile == null || this.getSection() == null) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        String path = this.getSection().getCurrentPath();
        Object object = sectionToLoad = path == null || path.isEmpty() ? config : config.getConfigurationSection(path);
        if (sectionToLoad == null) {
            return;
        }
        this.load(this.configFile, (ConfigurationSection)sectionToLoad);
    }

    public void saveToFile() {
        if (this.configFile == null) {
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (this.getSection() == null) {
                return;
            }
            for (String key : this.getSection().getKeys(true)) {
                config.set(key, this.getSection().get(key));
            }
            config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration to " + String.valueOf(this.configFile), e);
        }
    }
}

