/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.config.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.EnumUtil;
import net.bitbylogic.structures.lib.bitsutils.GenericHashMap;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.StringProcessor;
import net.bitbylogic.structures.lib.bitsutils.item.ItemStackUtil;
import net.bitbylogic.structures.lib.bitsutils.location.LocationUtil;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ConfiguredMetadata {
    private static final String RANDOM_MIN_KEY = "min-value";
    private static final String RANDOM_MAX_KEY = "max-value";
    private final GenericHashMap<String, Object> metadataMap = new GenericHashMap();
    private final GenericHashMap<String, Object> metadataDeepMap = new GenericHashMap();
    @Nullable
    private ConfigurationSection section;

    public ConfiguredMetadata() {
        this.section = null;
    }

    public ConfiguredMetadata(@Nullable ConfigurationSection section) {
        this.load(section);
    }

    public boolean hasKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadataMap.containsKey(key.toLowerCase());
    }

    public boolean hasKeyDeep(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadataDeepMap.containsKey(key.toLowerCase());
    }

    public <T> T getValueAsOrDefault(@NonNull String key, T defaultValue) {
        String string;
        block7: {
            T value;
            block6: {
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                value = this.metadataMap.getValueAsOrDefault(key.toLowerCase(), defaultValue);
                if (defaultValue instanceof Double && value instanceof Number) {
                    return (T)Double.valueOf(((Number)value).doubleValue());
                }
                if (defaultValue instanceof Integer && value instanceof Number) {
                    return (T)Integer.valueOf(((Number)value).intValue());
                }
                if (!(value instanceof String)) break block6;
                string = (String)value;
                if (defaultValue != null) break block7;
            }
            return value;
        }
        return (T)StringProcessor.findAndProcess(defaultValue.getClass(), string);
    }

    public <T> T getDeepValueAsOrDefault(@NonNull String key, T defaultValue) {
        String string;
        block7: {
            T value;
            block6: {
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                value = this.metadataDeepMap.getValueAsOrDefault(key.toLowerCase(), defaultValue);
                if (defaultValue instanceof Double && value instanceof Number) {
                    return (T)Double.valueOf(((Number)value).doubleValue());
                }
                if (defaultValue instanceof Integer && value instanceof Number) {
                    return (T)Integer.valueOf(((Number)value).intValue());
                }
                if (!(value instanceof String)) break block6;
                string = (String)value;
                if (defaultValue != null) break block7;
            }
            return value;
        }
        return (T)StringProcessor.findAndProcess(defaultValue.getClass(), string);
    }

    public Optional<ItemStack> getItem(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ConfigurationSection itemSection = this.metadataMap.getValueAsOrDefault(key.toLowerCase(), null);
        if (itemSection == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ItemStackUtil.getFromConfig(itemSection, new StringModifier[0]));
    }

    public Optional<Location> getLocation(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!this.metadataMap.containsKey(key.toLowerCase())) {
            return Optional.empty();
        }
        Object value = this.metadataMap.get(key.toLowerCase());
        if (!(value instanceof String)) {
            return Optional.empty();
        }
        String string = (String)value;
        return Optional.of(LocationUtil.stringToLocation(string));
    }

    public int getRandomIntInRange(int fallback) {
        if (!this.metadataMap.containsKey(RANDOM_MIN_KEY) && !this.metadataMap.containsKey(RANDOM_MAX_KEY)) {
            return fallback;
        }
        int min = this.metadataMap.getValueAsOrDefault(RANDOM_MIN_KEY, fallback);
        int max = this.metadataMap.getValueAsOrDefault(RANDOM_MAX_KEY, fallback);
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public double getRandomDoubleInRange(double fallback) {
        if (!this.metadataMap.containsKey(RANDOM_MIN_KEY) && !this.metadataMap.containsKey(RANDOM_MAX_KEY)) {
            return fallback;
        }
        double min = this.metadataMap.getValueAsOrDefault(RANDOM_MIN_KEY, fallback);
        double max = this.metadataMap.getValueAsOrDefault(RANDOM_MAX_KEY, fallback);
        return ThreadLocalRandom.current().nextDouble(min, max + 1.0);
    }

    public <T extends Enum<T>> T getEnum(@NonNull Class<T> enumClass, @NonNull String key, @NonNull T fallback) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return EnumUtil.getValue(enumClass, this.getValueAsOrDefault(key.toLowerCase(), fallback.name()), fallback);
    }

    public <T extends Enum<T>> Set<T> getEnumSet(@NonNull Class<T> enumClass, @NonNull String key, @NonNull Set<T> fallback) {
        HashSet<T> result;
        block8: {
            String[] parts;
            Object raw;
            block7: {
                if (enumClass == null) {
                    throw new NullPointerException("enumClass is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                if (fallback == null) {
                    throw new NullPointerException("fallback is marked non-null but is null");
                }
                raw = this.metadataMap.getValueAsOrDefault(key.toLowerCase(), null);
                if (raw == null) {
                    return fallback;
                }
                if (raw instanceof Set) {
                    return raw;
                }
                result = new HashSet<T>();
                if (!(raw instanceof List)) break block7;
                List list = raw;
                for (Object element : list) {
                    String str;
                    Object parsed;
                    if (!(element instanceof String) || (parsed = EnumUtil.getValue(enumClass, str = (String)element, null)) == null) continue;
                    result.add(parsed);
                }
                break block8;
            }
            if (!(raw instanceof String)) break block8;
            String str = raw;
            for (String part : parts = str.split(":")) {
                Object parsed = EnumUtil.getValue(enumClass, part.trim(), null);
                if (parsed == null) continue;
                result.add(parsed);
            }
        }
        return result.isEmpty() ? fallback : result;
    }

    public void load(@Nullable ConfigurationSection section) {
        this.section = section;
        this.metadataMap.clear();
        this.metadataDeepMap.clear();
        if (section == null) {
            return;
        }
        section.getKeys(false).forEach(key -> this.metadataMap.put(key.toLowerCase(), section.get(key)));
        section.getKeys(true).forEach(key -> this.metadataDeepMap.put(key.toLowerCase(), section.get(key)));
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConfiguredMetadata that = (ConfiguredMetadata)object;
        return Objects.equals(this.metadataMap, that.metadataMap) && Objects.equals(this.metadataDeepMap, that.metadataDeepMap) && Objects.equals(this.section, that.section);
    }

    public int hashCode() {
        return Objects.hash(this.metadataMap, this.metadataDeepMap, this.section);
    }

    @Generated
    public GenericHashMap<String, Object> getMetadataMap() {
        return this.metadataMap;
    }

    @Generated
    public GenericHashMap<String, Object> getMetadataDeepMap() {
        return this.metadataDeepMap;
    }

    @Nullable
    @Generated
    public ConfigurationSection getSection() {
        return this.section;
    }
}

