/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.context;

import java.util.UUID;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.context.ContextKey;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class ContextBuilder {
    private final Context context = new Context();

    public static ContextBuilder create() {
        return new ContextBuilder();
    }

    public ContextBuilder with(@NonNull UUID playerId) {
        if (playerId == null) {
            throw new NullPointerException("playerId is marked non-null but is null");
        }
        return this.with(Bukkit.getPlayer((UUID)playerId));
    }

    public ContextBuilder with(@Nullable Player player) {
        if (player == null) {
            return this;
        }
        this.context.put(BukkitContextKeys.PLAYER, player);
        return this;
    }

    public ContextBuilder with(@Nullable Entity entity) {
        if (entity == null) {
            return this;
        }
        this.context.put(BukkitContextKeys.ENTITY, entity);
        return this;
    }

    public ContextBuilder with(@NonNull CommandSender sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.with(player);
        }
        return this;
    }

    public <T> ContextBuilder with(@NonNull ContextKey<T> key, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.context.put(key, value);
        return this;
    }

    public ContextBuilder withAttribute(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.context.putAttribute(key, value);
        return this;
    }

    public Context build() {
        return this.context;
    }
}

