/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.context.registry;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.context.ContextKey;

public class ContextRegistry {
    private static final Map<String, ContextKey<?>> KEY_REGISTRY = new ConcurrentHashMap();

    public static <T> void register(@NonNull ContextKey<T> key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (KEY_REGISTRY.containsKey(key.getId().toLowerCase())) {
            return;
        }
        KEY_REGISTRY.putIfAbsent(key.getId().toLowerCase(), key);
    }

    public static void unregister(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        KEY_REGISTRY.remove(id.toLowerCase());
    }

    public static <T> Optional<ContextKey<T>> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        try {
            return Optional.ofNullable(KEY_REGISTRY.get(id.toLowerCase()));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<ContextKey<T>> get(@NonNull String id, @NonNull Class<T> type) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        ContextKey<?> key = KEY_REGISTRY.get(id.toLowerCase());
        if (key == null || !type.isAssignableFrom(key.getRawType())) {
            return Optional.empty();
        }
        return Optional.of(key);
    }

    public static Optional<?> getAndRetrieve(@NonNull Context context, @NonNull String id) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ContextRegistry.get(id).map(context::get);
    }

    public static <T> Optional<T> getAndRetrieve(@NonNull Context context, @NonNull String id, @NonNull Class<T> type) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ContextRegistry.get(id, type).flatMap(context::get);
    }

    public static <T> List<ContextKey<T>> allOfType(@NonNull Class<T> rawType) {
        if (rawType == null) {
            throw new NullPointerException("rawType is marked non-null but is null");
        }
        ArrayList result = new ArrayList();
        for (ContextKey<?> key : KEY_REGISTRY.values()) {
            if (!rawType.isAssignableFrom(key.getRawType())) continue;
            result.add(key);
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> List<ContextKey<T>> allOfGenericType(@NonNull Type genericType) {
        if (genericType == null) {
            throw new NullPointerException("genericType is marked non-null but is null");
        }
        ArrayList result = new ArrayList();
        for (ContextKey<?> key : KEY_REGISTRY.values()) {
            if (!key.getGenericType().equals(genericType)) continue;
            result.add(key);
        }
        return Collections.unmodifiableList(result);
    }

    public static Collection<ContextKey<?>> all() {
        return Collections.unmodifiableCollection(KEY_REGISTRY.values());
    }
}

