/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.dependency;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.dependency.DependencyListener;
import net.bitbylogic.structures.lib.bitsutils.dependency.annotation.Dependency;

public class DependencyManager {
    private final HashMap<Class<?>, Object> dependencies = new HashMap();
    private final HashMap<Class<?>, List<Object>> missingDependencies = new HashMap();
    private final List<DependencyListener> dependencyListeners = new ArrayList<DependencyListener>();

    public DependencyManager() {
        this.registerDependency(this.getClass(), this);
    }

    public <T> void registerDependency(Class<? extends T> clazz, T instance) {
        if (this.dependencies.containsKey(clazz)) {
            throw new IllegalStateException("There is already an instance of " + clazz.getSimpleName() + " registered!");
        }
        this.dependencies.put(clazz, instance);
        if (!this.missingDependencies.containsKey(clazz)) {
            return;
        }
        this.missingDependencies.get(clazz).forEach(obj -> this.injectDependencies(obj, true));
        this.missingDependencies.remove(clazz);
    }

    public void injectDependencies(@NonNull Object object, boolean deepInjection) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.injectFieldDependencies(object, deepInjection);
        if (this.missingDependencies.values().stream().anyMatch(objects -> objects.contains(object))) {
            return;
        }
        this.getDependencyMethods(object).forEach(method -> {
            try {
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    public boolean isDependencyRegistered(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.dependencies.containsKey(clazz);
    }

    public List<Class<?>> getDependencies(@NonNull Object object, boolean deepCheck) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.getDependencyFields(object, deepCheck).stream().map(field -> field.getType()).collect(Collectors.toList());
    }

    private void injectFieldDependencies(@NonNull Object object, boolean deepInjection) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.getDependencyFields(object, deepInjection).forEach(field -> this.resolveDependency((Field)field).ifPresentOrElse(dependency -> this.injectIntoField(object, (Field)field, dependency), () -> this.handleMissingDependency((Field)field, object)));
    }

    private Optional<Object> resolveDependency(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return Optional.ofNullable(this.dependencies.get(field.getType()));
    }

    private void handleMissingDependency(@NonNull Field field, @NonNull Object object) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        List pendingObjects = this.missingDependencies.getOrDefault(field.getType(), new ArrayList());
        if (pendingObjects.contains(object)) {
            return;
        }
        pendingObjects.add(object);
        this.missingDependencies.put(field.getType(), pendingObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectIntoField(@NonNull Object object, @NonNull Field field, @NonNull Object dependency) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency is marked non-null but is null");
        }
        boolean wasAccessible = field.canAccess(object);
        if (!wasAccessible && !field.trySetAccessible()) {
            return;
        }
        try {
            field.set(object, dependency);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        finally {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
        }
    }

    private Set<Field> getDependencyFields(@NonNull Object object, boolean deepInjection) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> clazz = object.getClass();
        HashSet<Field> dependencyFields = new HashSet<Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Dependency.class)) continue;
                dependencyFields.add(field);
            }
            clazz = clazz.getSuperclass();
        } while (deepInjection && clazz != null);
        return Set.copyOf(dependencyFields);
    }

    private Set<Method> getDependencyMethods(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> clazz = object.getClass();
        HashSet<Method> dependencyMethods = new HashSet<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Dependency.class) || method.getParameterCount() > 0) continue;
            dependencyMethods.add(method);
        }
        return Set.copyOf(dependencyMethods);
    }

    public void registerListener(@NonNull DependencyListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.dependencyListeners.add(listener);
        this.dependencies.forEach(listener::onRegistered);
    }

    @Generated
    public HashMap<Class<?>, Object> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public HashMap<Class<?>, List<Object>> getMissingDependencies() {
        return this.missingDependencies;
    }

    @Generated
    public List<DependencyListener> getDependencyListeners() {
        return this.dependencyListeners;
    }
}

