/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.item;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class ItemBuilder {
    private final ItemStack item;

    private ItemBuilder(ItemStack item) {
        this.item = item;
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilder(new ItemStack(material));
    }

    public static ItemBuilder from(ItemStack item) {
        return new ItemBuilder(item);
    }

    public ItemBuilder name(String name) {
        ItemMeta stackMeta = this.item.getItemMeta();
        stackMeta.setDisplayName(Formatter.format(name, new StringModifier[0]));
        this.item.setItemMeta(stackMeta);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder lore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> newLore = meta.getLore();
        if (newLore == null) {
            newLore = new ArrayList<String>();
        }
        for (String s : lore) {
            newLore.add(Formatter.format(s, new StringModifier[0]));
        }
        meta.setLore(newLore);
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        for (String part : lore) {
            this.lore(part);
        }
        return this;
    }

    public ItemBuilder data(short data) {
        this.item.setDurability(data);
        return this;
    }

    public ItemBuilder durability(short durability) {
        this.item.setDurability(durability);
        return this;
    }

    public ItemBuilder modelData(int modelData) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(modelData));
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder removeAttributes() {
        ItemMeta meta = this.item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder unbreakable() {
        ItemMeta meta = this.item.getItemMeta();
        meta.setUnbreakable(true);
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder hideToolTip() {
        ItemMeta meta = this.item.getItemMeta();
        meta.setHideTooltip(true);
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder flags(ItemFlag ... flags) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.addItemFlags(flags);
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder skullName(@NonNull String skullName) {
        if (skullName == null) {
            throw new NullPointerException("skullName is marked non-null but is null");
        }
        ItemMeta meta = this.item.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        skullMeta.setOwner(skullName);
        this.item.setItemMeta((ItemMeta)skullMeta);
        return this;
    }

    public ItemBuilder skullURL(@NonNull String skullURL) {
        if (skullURL == null) {
            throw new NullPointerException("skullURL is marked non-null but is null");
        }
        ItemMeta meta = this.item.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        PlayerProfile skullProfile = Bukkit.createPlayerProfile((String)"Notch");
        PlayerTextures textures = skullProfile.getTextures();
        textures.clear();
        try {
            textures.setSkin(URI.create(skullURL).toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        skullProfile.setTextures(textures);
        skullMeta.setOwnerProfile(skullProfile);
        this.item.setItemMeta((ItemMeta)skullMeta);
        return this;
    }

    public <T, Z> ItemBuilder addPersistentData(JavaPlugin plugin, String key, PersistentDataType<T, Z> type, Z value) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, key), type, value);
        this.item.setItemMeta(meta);
        return this;
    }

    public <T, Z> ItemBuilder addPersistentData(NamespacedKey namespacedKey, PersistentDataType<T, Z> type, Z value) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.getPersistentDataContainer().set(namespacedKey, type, value);
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemBuilder spawner(JavaPlugin plugin, EntityType entityType) {
        ItemMeta meta = this.item.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "bits_spawner"), PersistentDataType.STRING, (Object)entityType.name());
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        return this.item;
    }
}

