/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.StringUtil;
import net.bitbylogic.structures.lib.bitsutils.item.ItemStackConfigSerializer;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemStackUtil {
    private static final ItemStackConfigSerializer CONFIG_PARSER = new ItemStackConfigSerializer();

    public static ItemStack getFromConfig(@NonNull ConfigurationSection section, StringModifier ... modifiers) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        Optional<ItemStack> optionalItem = CONFIG_PARSER.serializeFrom(section);
        if (optionalItem.isEmpty()) {
            return new ItemStack(Material.OAK_LOG);
        }
        ItemStack item = optionalItem.get();
        ItemStackUtil.updateItem(item, modifiers);
        return item;
    }

    public static void saveToConfig(@NonNull ConfigurationSection section, @NonNull ItemStack item) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        CONFIG_PARSER.serializeTo(section, item);
    }

    public static String getVanillaName(ItemStack item) {
        return Formatter.format("&f" + StringUtil.capitalize(item.getType().name().replace("_", " ")), new StringModifier[0]);
    }

    public static void updateItem(ItemStack item, StringModifier ... modifiers) {
        if (item == null || !item.hasItemMeta() || item.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Formatter.format(meta.getDisplayName(), modifiers));
        if (meta.hasLore() && meta.getLore() != null) {
            List lore = meta.getLore();
            ArrayList updatedLore = Lists.newArrayList();
            lore.forEach(string -> updatedLore.add(Formatter.format(string, modifiers)));
            meta.setLore((List)updatedLore);
        }
        item.setItemMeta(meta);
    }

    public static void mergeLore(ItemStack main, ItemStack ... otherStacks) {
        if (main.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = main.getItemMeta();
        List mainLore = meta.hasLore() ? meta.getLore() : Lists.newArrayList();
        for (ItemStack otherItem : otherStacks) {
            if (otherItem.getItemMeta() == null || otherItem.getItemMeta().getLore() == null || !otherItem.getItemMeta().hasLore()) continue;
            mainLore.addAll(otherItem.getItemMeta().getLore());
        }
        meta.setLore(mainLore);
        main.setItemMeta(meta);
    }

    public static List<String> getMergedLore(ItemStack ... items) {
        ArrayList lore = Lists.newArrayList();
        for (ItemStack item : items) {
            if (item.getItemMeta() == null || item.getItemMeta().getLore() == null || !item.getItemMeta().hasLore()) continue;
            lore.addAll(item.getItemMeta().getLore());
        }
        return lore;
    }

    public static boolean isSimilar(ItemStack item, ItemStack otherItem, boolean compareFlags, boolean compareName, boolean compareLore) {
        if (item == null || otherItem == null) {
            return false;
        }
        if (item.getType() != otherItem.getType()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        ItemMeta otherMeta = otherItem.getItemMeta();
        if (compareFlags) {
            Set otherFlags;
            Set flags = meta == null ? Collections.emptySet() : meta.getItemFlags();
            Set set = otherFlags = otherMeta == null ? Collections.emptySet() : otherMeta.getItemFlags();
            if (!flags.equals(otherFlags)) {
                return false;
            }
        }
        if (compareName) {
            String otherName;
            String name = meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null;
            String string = otherName = otherMeta != null && otherMeta.hasDisplayName() ? otherMeta.getDisplayName() : null;
            if (!Objects.equals(name, otherName)) {
                return false;
            }
        }
        if (compareLore) {
            List lore = meta != null && meta.hasLore() ? meta.getLore() : null;
            List otherLore = otherMeta != null && otherMeta.hasLore() ? otherMeta.getLore() : null;
            return Objects.equals(lore, otherLore);
        }
        return true;
    }

    public static boolean flagsMatch(ItemStack item, ItemStack otherItem) {
        if (item.getItemMeta() == null && otherItem.getItemMeta() == null) {
            return true;
        }
        Set itemFlags = item.getItemMeta().getItemFlags();
        Set otherItemFlags = otherItem.getItemMeta().getItemFlags();
        return itemFlags.equals(otherItemFlags);
    }

    public static boolean loreMatches(ItemStack item, ItemStack otherItem) {
        if (item.getItemMeta() == null && otherItem.getItemMeta() == null) {
            return true;
        }
        if (item.getItemMeta() == null || otherItem.getItemMeta() == null) {
            return false;
        }
        if (item.getItemMeta().hasLore() != otherItem.getItemMeta().hasLore()) {
            return false;
        }
        List itemLore = item.getItemMeta().getLore();
        List otherItemLore = otherItem.getItemMeta().getLore();
        if (itemLore == null && otherItemLore == null) {
            return true;
        }
        if (itemLore == null || otherItemLore == null) {
            return false;
        }
        return itemLore.equals(otherItemLore);
    }

    public static boolean spawnerMatches(ItemStack item, ItemStack otherItem) {
        if (item.getType() != Material.SPAWNER || otherItem.getType() != Material.SPAWNER) {
            return false;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        BlockStateMeta otherMeta = (BlockStateMeta)otherItem.getItemMeta();
        if (meta == null || otherMeta == null) {
            return false;
        }
        return ((CreatureSpawner)meta.getBlockState()).getSpawnedType() != ((CreatureSpawner)otherMeta.getBlockState()).getSpawnedType();
    }

    public static ItemStack getSpawner(JavaPlugin plugin, EntityType entityType, String name) {
        ItemStack item = new ItemStack(Material.SPAWNER);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.setDisplayName(Formatter.format(name, new StringModifier[0]));
        }
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "bits_spawner"), PersistentDataType.STRING, (Object)entityType.name());
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setSpawner(JavaPlugin plugin, ItemStack item, EntityType entityType) {
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, "bits_spawner"), PersistentDataType.STRING, (Object)entityType.name());
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isSpawner(JavaPlugin plugin, ItemStack item) {
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)plugin, "bits_spawner"), PersistentDataType.STRING);
    }

    public static EntityType getSpawnerEntity(JavaPlugin plugin, ItemStack item) {
        if (!ItemStackUtil.isSpawner(plugin, item)) {
            return null;
        }
        return EntityType.valueOf((String)((String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)plugin, "bits_spawner"), PersistentDataType.STRING)));
    }

    public static <P, C> void addPersistentData(@NonNull ItemStack item, @NonNull NamespacedKey key, @NonNull PersistentDataType<P, C> dataType, C value) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(key, dataType, value);
        item.setItemMeta(meta);
    }

    public static boolean hasPersistentData(ItemStack itemStack, String key) {
        return itemStack.getItemMeta().getPersistentDataContainer().getKeys().stream().anyMatch(pKey -> pKey.getKey().equalsIgnoreCase(key));
    }

    public static boolean hasPersistentData(@NonNull ItemStack item, @NonNull NamespacedKey key) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(key);
    }

    public static <P, C> Optional<C> getPersistentData(@NonNull ItemStack item, @NonNull NamespacedKey key, @NonNull PersistentDataType<P, C> dataType) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !ItemStackUtil.hasPersistentData(item, key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(meta.getPersistentDataContainer().get(key, dataType));
    }

    public static <T, Z> boolean persistentDataMatches(ItemStack itemStack, PersistentDataType<T, Z> type, Z value) {
        PersistentDataContainer dataContainer = itemStack.getItemMeta().getPersistentDataContainer();
        return dataContainer.getKeys().stream().filter(pKey -> dataContainer.has(pKey, type)).anyMatch(pKey -> dataContainer.get(pKey, type) == value);
    }

    public static void setSkullOwner(ItemStack stack, String owner) {
        if (stack.getType() != Material.PLAYER_HEAD) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)stack.getItemMeta();
        skullMeta.setOwner(owner);
        stack.setItemMeta((ItemMeta)skullMeta);
    }

    public static boolean isSword(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getType().name().endsWith("_SWORD");
    }

    public static boolean isAxe(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getType().name().endsWith("_AXE");
    }

    public static boolean isPickaxe(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getType().name().endsWith("_PICKAXE");
    }

    public static boolean isHoe(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getType().name().endsWith("_HOE");
    }

    public static boolean isShovel(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getType().name().endsWith("_SHOVEL");
    }
}

