/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.location;

import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.location.LocationUtil;
import net.bitbylogic.structures.lib.bitsutils.location.OffsetLocationConfigSerializer;
import org.bukkit.Location;

public class OffsetLocation {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public static OffsetLocation fromString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        String[] data = string.split(":");
        if (data.length < 3) {
            return new OffsetLocation(0.0, 0.0, 0.0);
        }
        return new OffsetLocation(Double.parseDouble(data[0]), Double.parseDouble(data[1]), Double.parseDouble(data[2]));
    }

    @NonNull
    public static OffsetLocation of(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return new OffsetLocation(location.getX(), location.getY(), location.getZ());
    }

    public static OffsetLocationConfigSerializer getParser() {
        return new OffsetLocationConfigSerializer();
    }

    @NonNull
    public Location apply(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return location.clone().add(this.xOffset, this.yOffset, this.zOffset);
    }

    public boolean matches(@NonNull Location location, @NonNull Location center) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (center == null) {
            throw new NullPointerException("center is marked non-null but is null");
        }
        return LocationUtil.matches(this.apply(center.clone()), LocationUtil.toBlockLocation(location));
    }

    public double distance(@NonNull OffsetLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        double dx = location.getXOffset() - this.xOffset;
        double dy = location.getYOffset() - this.yOffset;
        double dz = location.getZOffset() - this.zOffset;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean isAdjacent(@NonNull OffsetLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return (this.xOffset != location.getXOffset() ? 1 : 0) + (this.yOffset != location.getYOffset() ? 1 : 0) + (this.zOffset != location.getZOffset() ? 1 : 0) == 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OffsetLocation that = (OffsetLocation)object;
        return Double.compare(this.xOffset, that.xOffset) == 0 && Double.compare(this.yOffset, that.yOffset) == 0 && Double.compare(this.zOffset, that.zOffset) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.xOffset, this.yOffset, this.zOffset);
    }

    public String toString() {
        return String.format("%.2f:%.2f:%.2f", this.xOffset, this.yOffset, this.zOffset);
    }

    @Generated
    public OffsetLocation(double xOffset, double yOffset, double zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Generated
    public double getXOffset() {
        return this.xOffset;
    }

    @Generated
    public double getYOffset() {
        return this.yOffset;
    }

    @Generated
    public double getZOffset() {
        return this.zOffset;
    }
}

