/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.message;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ActionBarUtil {
    private static final Map<UUID, String> LAST_ACTION_BAR = new HashMap<UUID, String>();

    public static void sendActionBar(@NonNull Player player, @NonNull String id, @NonNull String message) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)Formatter.format(message, new StringModifier[0])));
        LAST_ACTION_BAR.put(player.getUniqueId(), id);
    }

    public static void resetIfUnchanged(@NonNull Player player, @NonNull String id) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (!LAST_ACTION_BAR.getOrDefault(player.getUniqueId(), "").equalsIgnoreCase(id)) {
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)Formatter.format("&a", new StringModifier[0])));
        LAST_ACTION_BAR.remove(player.getUniqueId());
    }
}

