/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.message.format;

import java.io.File;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.LivePlaceholder;
import net.bitbylogic.structures.lib.bitsutils.config.configurable.Configurable;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;

public class FormatConfig
extends Configurable {
    public FormatConfig(@NonNull File configFile) {
        super(configFile, false, "Formatting.", FormatConfig.pair("Center-Pixels", 154), FormatConfig.pair("Symbols.Right-Arrow", "\u00bb"), FormatConfig.pair("Symbols.Dot", "\u2022"), FormatConfig.pair("Patterns.Placeholder", "%.+?%"), FormatConfig.pair("Patterns.Format", "<([a-zA-Z0-9 _]+)>(.*?)</\\1>|<([a-zA-Z0-9 _]+)#(.*?)>(.*?)</\\3>"), FormatConfig.pair("Patterns.Hex", "#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})"), FormatConfig.pair("Patterns.Spigot-Hex", "\u00a7x(\u00a7[a-fA-F0-9]){6}\u00a7r"), FormatConfig.pair("Command", " <c#primary>/%command%</c> &8\u2500 <c#secondary>%description%</c>"), FormatConfig.pair("Rich-Command.Text", " <c#primary>/%command%</c>"), FormatConfig.pair("Rich-Command.Hover", "<c#secondary>%description%</c>"), FormatConfig.pair("Main", "<c#primary>&l%prefix%</c> &8%dot% <c#secondary>%message%</c>"), FormatConfig.pair("Error", "<c#error_primary>&l%prefix%</c> &8%dot% <c#error_secondary>%message%</c>"), FormatConfig.pair("Success", "<c#success_primary>&l%prefix%</c> &8%dot% <c#success_secondary>%message%</c>"), FormatConfig.pair("List.Header", "<c#primary>&l%prefix%</c> &8%dot% <c#secondary>%info%</c>"), FormatConfig.pair("List.Item", "&8| &8\u00bb <c#success_primary>%prefix%</c> &8%dot% <c#success_secondary>%message%</c>"), FormatConfig.pair("Dotted-Message", "<c#success_primary>%prefix%</c> &8%dot% <c#success_secondary>%message%</c>"), FormatConfig.pair("Paged.Invalid-Page", "Invalid page!"), FormatConfig.pair("Paged.Item", "<c#separator>| \u00bb </c><c#highlight>%text%</c>"), FormatConfig.pair("Paged.Footer", "\u2937 &7(Page: %current-page%/%pages%)"));
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        Formatter.registerGlobalModifier(new LivePlaceholder("%right-arrow%", () -> (String)this.getConfigValue("Symbols.Right-Arrow")), new LivePlaceholder("%dot%", () -> (String)this.getConfigValue("Symbols.Dot")));
    }

    public Pattern getPlaceholderPattern() {
        return Pattern.compile((String)this.getConfigValue("Patterns.Placeholder"));
    }

    public Pattern getFormatPattern() {
        return Pattern.compile((String)this.getConfigValue("Patterns.Format"));
    }

    public Pattern getHexPattern() {
        return Pattern.compile((String)this.getConfigValue("Patterns.Hex"));
    }

    public Pattern getSpigotHexPattern() {
        return Pattern.compile((String)this.getConfigValue("Patterns.Spigot-Hex"));
    }
}

