/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.message.messages;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.StringModifier;
import net.bitbylogic.structures.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.message.format.Formatter;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageKey {
    @NonNull
    private final String path;
    @NonNull
    private final List<String> values;

    public MessageKey(@NonNull String path, @NonNull String defaultValue) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        this.path = path;
        this.values = new ArrayList<String>(List.of(defaultValue));
    }

    public MessageKey(@NonNull String path, @NonNull List<String> defaultValue) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        this.path = path;
        this.values = new ArrayList<String>(defaultValue);
    }

    public String get(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return this.get(new StringModifier[0]);
    }

    public String get(@NonNull Player player, StringModifier ... modifiers) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.get(modifiers);
    }

    public String get(StringModifier ... modifiers) {
        return Formatter.format(this.values.getFirst(), modifiers);
    }

    public void send(@NonNull Context context, StringModifier ... modifiers) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
        if (player == null) {
            return;
        }
        this.send((CommandSender)player, modifiers);
    }

    public void send(@NonNull CommandSender sender, StringModifier ... modifiers) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.values.forEach(message -> sender.sendMessage(Formatter.format(message, modifiers)));
    }

    @NonNull
    @Generated
    public String getPath() {
        return this.path;
    }

    @NonNull
    @Generated
    public List<String> getValues() {
        return this.values;
    }
}

