/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.bitbylogic.structures.lib.bitsutils.reflection.NamedParameter;

public class ReflectionUtil {
    public static Field findField(Class<?> clazz, String fieldName) {
        Class<?> currentClass = clazz;
        while (true) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                if ((currentClass = currentClass.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    public static boolean isListOf(Field field, Class<?> entryClass) {
        ParameterizedType parameterizedType;
        Type[] arguments;
        field.setAccessible(true);
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
            return arguments[0].getClass().isInstance(entryClass);
        }
        return false;
    }

    public static boolean isMapOf(Field field, Class<?> valueClass) {
        ParameterizedType parameterizedType;
        Type[] arguments;
        field.setAccessible(true);
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length > 1) {
            return arguments[1].getClass().isInstance(valueClass);
        }
        return false;
    }

    public static Class<?> getParameterizedType(Field field, Class<?> valueClass) {
        field.setAccessible(true);
        if (ReflectionUtil.isListOf(field, valueClass)) {
            ParameterizedType parameterizedType;
            Type[] arguments;
            Type fieldType = field.getGenericType();
            if (fieldType instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
                return arguments[0].getClass().isInstance(valueClass) ? arguments[0].getClass() : null;
            }
            return null;
        }
        if (ReflectionUtil.isMapOf(field, valueClass)) {
            ParameterizedType parameterizedType;
            Type[] arguments;
            Type fieldType = field.getGenericType();
            if (fieldType instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length > 1) {
                return arguments[1].getClass().isInstance(valueClass) ? arguments[1].getClass() : null;
            }
            return null;
        }
        return field.getType();
    }

    public static void createAndPopulateField(Object targetObject, Field field, Object[] values) throws IllegalAccessException {
        field.setAccessible(true);
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Class fieldClass = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(fieldClass)) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(values));
                field.set(targetObject, list);
            }
            if (!Map.class.isAssignableFrom(fieldClass)) {
                return;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < values.length; i += 2) {
                if (i + 1 >= values.length) continue;
                map.put(values[i], values[i + 1]);
            }
            field.set(targetObject, map);
        }
    }

    public static <T> Constructor<T> findNamedConstructor(Class<T> clazz, NamedParameter ... parameters) {
        ArrayList parameterClasses = new ArrayList();
        for (NamedParameter parameter : parameters) {
            parameterClasses.add(parameter.getValueClass());
        }
        return ReflectionUtil.findConstructor(clazz, parameterClasses.toArray(new Class[0]));
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Object ... parameters) {
        LinkedList parameterClasses = new LinkedList();
        for (Object parameter : parameters) {
            parameterClasses.add(parameter.getClass());
        }
        return ReflectionUtil.findConstructor(clazz, parameterClasses.toArray(new Class[0]));
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... parameters) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != parameters.length || !new HashSet(List.of(constructor.getParameterTypes())).containsAll(List.of(parameters))) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T callConstructor(Constructor<T> constructor, NamedParameter ... parameters) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<String, NamedParameter> parameterMap = new HashMap<String, NamedParameter>();
        for (NamedParameter parameter : parameters) {
            parameterMap.put(parameter.getName(), parameter);
        }
        Parameter[] constructorParameters = constructor.getParameters();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] orderedParameters = new Object[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = constructorParameters[i];
            NamedParameter namedParameter = (NamedParameter)parameterMap.get(parameter.getName());
            if (namedParameter == null) {
                throw new NullPointerException("Unable to find named parameter for parameter: " + parameter.getName());
            }
            orderedParameters[i] = namedParameter.getValue();
        }
        return constructor.newInstance(orderedParameters);
    }

    public static <T> T callConstructor(Constructor<T> constructor, Object ... parameters) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap parameterMap = new HashMap();
        for (Object parameter : parameters) {
            parameterMap.put(parameter.getClass(), parameter);
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] orderedParameters = new Object[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            orderedParameters[i] = parameterMap.get(parameterTypes[i]);
        }
        return constructor.newInstance(orderedParameters);
    }

    public static <T> T findAndCallConstructor(Class<T> clazz, Object ... parameters) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<T> constructor = ReflectionUtil.findConstructor(clazz, parameters);
        if (constructor == null) {
            return null;
        }
        HashMap parameterMap = new HashMap();
        for (Object parameter : parameters) {
            parameterMap.put(parameter.getClass(), parameter);
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] orderedParameters = new Object[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            orderedParameters[i] = parameterMap.get(parameterTypes[i]);
        }
        return constructor.newInstance(orderedParameters);
    }

    public static <T> T findAndCallConstructor(Class<T> clazz, NamedParameter ... parameters) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<T> constructor = ReflectionUtil.findConstructor(clazz, Arrays.stream(parameters).map(named -> named.getValue().getClass()).collect(Collectors.toSet()).toArray(new Class[0]));
        if (constructor == null) {
            return null;
        }
        HashMap<String, NamedParameter> parameterMap = new HashMap<String, NamedParameter>();
        for (NamedParameter parameter : parameters) {
            parameterMap.put(parameter.getName(), parameter);
        }
        Parameter[] constructorParameters = constructor.getParameters();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] orderedParameters = new Object[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = constructorParameters[i];
            NamedParameter namedParameter = (NamedParameter)parameterMap.get(parameter.getName());
            if (namedParameter == null) {
                throw new NullPointerException("Unable to find named parameter for parameter :" + parameter.getName());
            }
            orderedParameters[i] = namedParameter.getValue();
        }
        return constructor.newInstance(orderedParameters);
    }

    public static <T> boolean isType(Object obj, Class<T> clazz) {
        return clazz.isInstance(obj) || clazz.isPrimitive() && ReflectionUtil.getWrapperType(clazz).isInstance(obj);
    }

    private static Class<?> getWrapperType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        return Void.class;
    }
}

