/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.trigger;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.structures.lib.bitsutils.context.Context;
import net.bitbylogic.structures.lib.bitsutils.trigger.Trigger;
import net.bitbylogic.structures.lib.bitsutils.trigger.TriggerAction;
import net.bitbylogic.structures.lib.bitsutils.trigger.TriggerRegistry;
import org.jetbrains.annotations.Nullable;

public class DeferredTrigger
implements Trigger {
    private final String targetId;
    private final ConfiguredMetadata metadata;
    @Nullable
    private volatile Trigger delegate;
    private final List<Consumer<Trigger>> whenAvailableCallbacks = new CopyOnWriteArrayList<Consumer<Trigger>>();

    public DeferredTrigger(@NonNull String targetId, @NonNull ConfiguredMetadata metadata) {
        if (targetId == null) {
            throw new NullPointerException("targetId is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.targetId = targetId;
        this.metadata = metadata;
    }

    private synchronized Trigger resolve() {
        if (this.delegate == null) {
            Optional<Trigger> provided = TriggerRegistry.get(this.targetId).map(provider -> provider.provide(this.metadata));
            if (provided.isEmpty()) {
                throw new IllegalStateException("Could not resolve trigger: " + this.targetId);
            }
            this.delegate = provided.get();
            for (Consumer<Trigger> callback : this.whenAvailableCallbacks) {
                callback.accept(this.delegate);
            }
            this.whenAvailableCallbacks.clear();
        }
        return this.delegate;
    }

    public void whenAvailable(@NonNull Consumer<Trigger> callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (this.delegate != null) {
            callback.accept(this.delegate);
            return;
        }
        this.whenAvailableCallbacks.add(callback);
    }

    @Override
    @NonNull
    public String getId() {
        return this.targetId;
    }

    @Override
    public boolean isActive() {
        return this.resolve().isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.resolve().setActive(active);
    }

    @Override
    public boolean isRepeatable() {
        return this.resolve().isRepeatable();
    }

    @Override
    public void setRepeatable(boolean repeatable) {
        this.resolve().setRepeatable(repeatable);
    }

    @Override
    public boolean isDeactivateChildren() {
        return this.resolve().isDeactivateChildren();
    }

    @Override
    @NonNull
    public List<Trigger> getChildren() {
        return this.resolve().getChildren();
    }

    @Override
    public void setAction(@NonNull TriggerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.resolve().setAction(action);
    }

    @Override
    @Nullable
    public TriggerAction getAction() {
        return this.resolve().getAction();
    }

    @Override
    public void trigger(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.resolve().trigger(context);
    }

    @Override
    public void onDeactivate(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.resolve().onDeactivate(context);
    }

    @Override
    @NonNull
    public Trigger clone() {
        DeferredTrigger cloned = new DeferredTrigger(this.targetId, this.metadata);
        if (this.delegate != null) {
            cloned.delegate = this.delegate.clone();
        }
        return cloned;
    }
}

