/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.lib.bitsutils.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bitbylogic.structures.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.structures.lib.bitsutils.trigger.DeferredTrigger;
import net.bitbylogic.structures.lib.bitsutils.trigger.Trigger;
import net.bitbylogic.structures.lib.bitsutils.trigger.TriggerAction;
import net.bitbylogic.structures.lib.bitsutils.trigger.TriggerRegistry;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class TriggerParser {
    public static List<Trigger> loadTriggers(@Nullable ConfigurationSection triggersSection) {
        return TriggerParser.loadTriggers(triggersSection, null);
    }

    public static List<Trigger> loadTriggers(@Nullable ConfigurationSection triggersSection, @Nullable TriggerAction action) {
        if (triggersSection == null) {
            return new ArrayList<Trigger>();
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        triggersSection.getKeys(false).forEach(key -> {
            ConfigurationSection triggerSection = triggersSection.getConfigurationSection(key);
            if (triggerSection == null) {
                return;
            }
            TriggerParser.parseTrigger(triggerSection, action).ifPresent(triggers::add);
        });
        for (Trigger trigger : triggers) {
            for (Trigger other : triggers) {
                if (trigger == other) continue;
                trigger.getChildren().add(other);
            }
        }
        return triggers;
    }

    public static Optional<Trigger> parseTrigger(@Nullable ConfigurationSection triggerSection) {
        return TriggerParser.parseTrigger(triggerSection, null);
    }

    public static Optional<Trigger> parseTrigger(@Nullable ConfigurationSection triggerSection, @Nullable TriggerAction action) {
        if (triggerSection == null) {
            return Optional.empty();
        }
        String id = triggerSection.getString("Trigger-ID");
        if (id == null) {
            return Optional.empty();
        }
        ConfigurationSection metadataSection = triggerSection.getConfigurationSection("Metadata");
        ConfiguredMetadata metadata = new ConfiguredMetadata(metadataSection);
        Optional<Trigger> resolved = TriggerRegistry.get(id).map(provider -> provider.provide(metadata));
        if (resolved.isPresent()) {
            return resolved;
        }
        return Optional.of(new DeferredTrigger(id, metadata));
    }
}

