/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.listener;

import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.packetblocks.event.PacketBlockBreakEvent;
import net.bitbylogic.structures.lib.bitsutils.Placeholder;
import net.bitbylogic.structures.lib.bitsutils.message.config.MessageProvider;
import net.bitbylogic.structures.manager.StructureManager;
import net.bitbylogic.structures.structure.Structure;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class StructureEditorListener
implements Listener {
    private final MessageProvider messageProvider;
    private final StructureManager structureManager;
    private final PacketBlockManager packetBlockManager;

    public StructureEditorListener(@NonNull MessageProvider messageProvider, @NonNull StructureManager structureManager) {
        if (messageProvider == null) {
            throw new NullPointerException("messageProvider is marked non-null but is null");
        }
        if (structureManager == null) {
            throw new NullPointerException("structureManager is marked non-null but is null");
        }
        this.messageProvider = messageProvider;
        this.structureManager = structureManager;
        this.packetBlockManager = PacketBlocks.getInstance().getBlockManager();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        String structureId = this.structureManager.getEditorMode().get(player.getUniqueId());
        if (structureId == null) {
            return;
        }
        Structure structure = this.structureManager.getStructures().get(structureId);
        if (structure == null) {
            return;
        }
        Location blockLocation = event.getBlock().getLocation();
        if (this.structureManager.getEditorModeLocations().get(player.getUniqueId()).contains(blockLocation)) {
            return;
        }
        this.structureManager.getEditorModeLocations().get(player.getUniqueId()).add(blockLocation);
        player.sendActionBar(this.messageProvider.getMessage("Editor.Action-Bar.Block-Added", new Placeholder("%x%", blockLocation.getBlockX()), new Placeholder("%y%", blockLocation.getBlockY()), new Placeholder("%z%", blockLocation.getBlockZ())));
    }

    @EventHandler
    public void onPacketBlockBreak(PacketBlockBreakEvent event) {
        Player player = event.getPlayer();
        String id = this.structureManager.getEditorMode().get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Structure structure = this.structureManager.getStructures().get(id);
        if (structure == null) {
            return;
        }
        Location targetBlockLoc = event.getBlock().getLocation();
        if (!structure.getBlocks().containsKey(targetBlockLoc)) {
            return;
        }
        structure.getBlocks().remove(targetBlockLoc);
        player.sendActionBar(this.messageProvider.getMessage("Editor.Action-Bar.Block-Removed", new Placeholder("%x%", targetBlockLoc.getBlockX()), new Placeholder("%y%", targetBlockLoc.getBlockY()), new Placeholder("%z%", targetBlockLoc.getBlockZ())));
        this.packetBlockManager.getBlock(targetBlockLoc).ifPresent(arg_0 -> ((PacketBlockManager)this.packetBlockManager).removeBlock(arg_0));
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        String id = this.structureManager.getEditorMode().get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Structure structure = this.structureManager.getStructures().get(id);
        if (structure == null) {
            return;
        }
        Location targetBlockLoc = event.getBlock().getLocation();
        if (!structure.getBlocks().containsKey(targetBlockLoc) && !this.structureManager.getEditorModeLocations().get(player.getUniqueId()).contains(targetBlockLoc)) {
            return;
        }
        structure.getBlocks().remove(targetBlockLoc);
        this.structureManager.getEditorModeLocations().get(player.getUniqueId()).remove(targetBlockLoc);
        player.sendActionBar(this.messageProvider.getMessage("Editor.Action-Bar.Block-Removed", new Placeholder("%x%", targetBlockLoc.getBlockX()), new Placeholder("%y%", targetBlockLoc.getBlockY()), new Placeholder("%z%", targetBlockLoc.getBlockZ())));
        this.packetBlockManager.getBlock(targetBlockLoc).ifPresent(arg_0 -> ((PacketBlockManager)this.packetBlockManager).removeBlock(arg_0));
    }
}

