/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.listener;

import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.structures.Structures;
import net.bitbylogic.structures.manager.StructureManager;
import net.bitbylogic.structures.structure.Structure;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class StructureListener
implements Listener {
    private final Structures plugin;
    private final StructureManager structureManager;
    private final PacketBlockManager packetBlockManager;

    public StructureListener(@NonNull Structures plugin, @NonNull StructureManager structureManager) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (structureManager == null) {
            throw new NullPointerException("structureManager is marked non-null but is null");
        }
        this.plugin = plugin;
        this.structureManager = structureManager;
        this.packetBlockManager = PacketBlocks.getInstance().getBlockManager();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Structure structure : this.structureManager.getStructures().values()) {
                if (structure.isRequireTrigger() || structure.getShowConditions().stream().anyMatch(condition -> !condition.test(player))) continue;
                this.structureManager.addViewer(structure.getId(), player);
            }
        }, 5L);
    }

    @EventHandler
    public void onQuit(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.structureManager.getStructureViewers().forEach((key, value) -> value.remove(player.getUniqueId()));
        this.packetBlockManager.getBlocksByMetadata("structure").forEach(block -> block.removeViewer(player));
    }
}

