/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.structures.Structures;
import net.bitbylogic.structures.animation.StructureAnimation;
import net.bitbylogic.structures.animation.StructureAnimationManager;
import net.bitbylogic.structures.context.StructureContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.structures.lib.bitsutils.context.ContextBuilder;
import net.bitbylogic.structures.structure.Structure;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StructureManager {
    public static final String PACKET_BLOCK_METADATA_KEY = "structure";
    private final Map<String, Structure> structures = new HashMap<String, Structure>();
    private final Map<String, Set<UUID>> structureViewers = new HashMap<String, Set<UUID>>();
    private final Map<UUID, String> editorMode = new HashMap<UUID, String>();
    private final Map<UUID, List<Location>> editorModeLocations = new HashMap<UUID, List<Location>>();
    private final Structures plugin;
    private final StructureAnimationManager animationManager;
    private final PacketBlockManager packetBlockManager;

    public StructureManager(@NonNull Structures plugin, @NonNull StructureAnimationManager animationManager) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (animationManager == null) {
            throw new NullPointerException("animationManager is marked non-null but is null");
        }
        this.plugin = plugin;
        this.animationManager = animationManager;
        this.packetBlockManager = PacketBlocks.getInstance().getBlockManager();
        this.loadStructures();
    }

    public void loadStructures() {
        this.structures.values().forEach(structure -> {
            this.getViewers(structure.getId()).forEach(viewer -> this.removeViewer(structure.getId(), Bukkit.getPlayer((UUID)viewer)));
            this.packetBlockManager.removeIf(pb -> pb.hasMetadata(this.createStructureIdMetadataKey(structure.getId())));
            structure.getShowTriggers().forEach(trigger -> trigger.setActive(false));
            structure.getHideTriggers().forEach(trigger -> trigger.setActive(false));
        });
        this.structures.clear();
        this.structureViewers.clear();
        this.editorMode.values().forEach(structureId -> this.structureViewers.put((String)structureId, new HashSet()));
        for (String structureId2 : this.plugin.getStructureConfig().getKeys(false)) {
            ConfigurationSection structureSection = this.plugin.getStructureConfig().getConfigurationSection(structureId2);
            if (structureSection == null) continue;
            Structure.getConfigParser().serializeFrom(structureSection).ifPresent(structure -> {
                this.structures.put(structureId2, (Structure)structure);
                this.structureViewers.put(structureId2, new HashSet());
                this.loadShowTriggers((Structure)structure);
                this.loadHideTriggers((Structure)structure);
                structure.getBlocks().forEach((location, blockData) -> this.createPacketBlock(structure.getId(), (Location)location, (BlockData)blockData));
                this.plugin.getLogger().log(Level.INFO, String.format("Loaded structure %s (%d blocks)", structure.getId(), structure.getBlocks().size()));
            });
        }
        this.structures.values().forEach(structure -> {
            if (structure.isRequireTrigger()) {
                return;
            }
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (structure.getShowConditions().stream().anyMatch(condition -> !condition.test(player))) {
                    return;
                }
                this.addViewer(structure.getId(), (Player)player);
            });
        });
    }

    protected String createStructureIdMetadataKey(String structureId) {
        return "structure_" + structureId;
    }

    private void loadShowTriggers(Structure structure) {
        structure.getShowTriggers().forEach(trigger -> {
            trigger.setActive(true);
            trigger.setAction(context -> {
                Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
                if (player == null || ((Set)this.structureViewers.getOrDefault(structure.getId(), new HashSet())).contains(player.getUniqueId())) {
                    return;
                }
                if (structure.getShowConditions().stream().anyMatch(condition -> !condition.test(player))) {
                    return;
                }
                this.addViewer(structure.getId(), player);
            });
        });
    }

    private void loadHideTriggers(Structure structure) {
        structure.getHideTriggers().forEach(trigger -> {
            trigger.setActive(true);
            trigger.setAction(context -> {
                Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
                if (player == null || !((Set)this.structureViewers.getOrDefault(structure.getId(), new HashSet())).contains(player.getUniqueId())) {
                    return;
                }
                if (structure.getHideConditions().stream().anyMatch(condition -> !condition.test(player))) {
                    return;
                }
                this.removeViewer(structure.getId(), player);
            });
        });
    }

    @ApiStatus.Internal
    public PacketBlock createPacketBlock(String structureId, Location location, BlockData data) {
        PacketBlock packetBlock = this.packetBlockManager.createBlock(location, data);
        packetBlock.setBlockDataSupplierForAll(data);
        packetBlock.addMetadata(PACKET_BLOCK_METADATA_KEY, (Object)structureId);
        packetBlock.addMetadata(this.createStructureIdMetadataKey(structureId), (Object)true);
        return packetBlock;
    }

    public Set<PacketBlock> getPacketBlocks(@NonNull String structureId) {
        if (structureId == null) {
            throw new NullPointerException("structureId is marked non-null but is null");
        }
        if (!this.structures.containsKey(structureId)) {
            return new HashSet<PacketBlock>();
        }
        return Set.of(this.packetBlockManager.getBlocksByMetadata(this.createStructureIdMetadataKey(structureId)).toArray(new PacketBlock[0]));
    }

    public Optional<Structure> createStructure(String structureId) {
        if (this.structures.containsKey(structureId)) {
            return Optional.empty();
        }
        Structure structure = new Structure(structureId);
        this.structures.put(structureId, structure);
        this.structureViewers.put(structureId, new HashSet());
        return Optional.of(structure);
    }

    public boolean saveStructure(String structureId) {
        Structure structure = this.structures.get(structureId);
        if (structure == null) {
            return false;
        }
        if (!structure.getBlocks().isEmpty()) {
            Structure.getConfigParser().serializeTo((ConfigurationSection)this.plugin.getStructureConfig(), structure);
            this.plugin.saveStructureConfig();
            return true;
        }
        this.deleteStructure(structureId);
        return true;
    }

    public boolean deleteStructure(String structureId) {
        Structure structure = this.structures.get(structureId);
        if (structure == null) {
            return false;
        }
        this.packetBlockManager.removeIf(pb -> pb.hasMetadata(this.createStructureIdMetadataKey(structureId)));
        this.plugin.getStructureConfig().set(structureId, null);
        this.plugin.saveStructureConfig();
        this.structureViewers.remove(structureId);
        this.structures.remove(structureId);
        return true;
    }

    public Optional<Structure> getStructure(@NonNull String structureId) {
        if (structureId == null) {
            throw new NullPointerException("structureId is marked non-null but is null");
        }
        return Optional.ofNullable(this.structures.get(structureId));
    }

    public boolean addViewer(@NonNull String structureId, @NonNull Player player) {
        if (structureId == null) {
            throw new NullPointerException("structureId is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Set<UUID> viewers = this.structureViewers.get(structureId);
        if (viewers == null) {
            return false;
        }
        viewers.add(player.getUniqueId());
        ArrayList states = new ArrayList();
        this.packetBlockManager.getBlocksByMetadata(this.createStructureIdMetadataKey(structureId)).forEach(block -> {
            block.addViewer(player);
            states.add(block.getBlockState(player));
        });
        player.sendBlockChanges(states);
        this.getStructure(structureId).ifPresent(structure -> this.animationManager.getAnimation(structure.getAppearAnimationId()).ifPresent(structureAnimation -> structureAnimation.onActivate(ContextBuilder.create().with(player).with(StructureContextKeys.STRUCTURE, structure).with(StructureContextKeys.ANIMATION_TYPE, StructureAnimation.Type.SHOW).build())));
        return true;
    }

    public boolean removeViewer(@NonNull String structureId, @Nullable Player player) {
        if (structureId == null) {
            throw new NullPointerException("structureId is marked non-null but is null");
        }
        Set<UUID> viewers = this.structureViewers.get(structureId);
        if (viewers == null || player == null) {
            return false;
        }
        viewers.remove(player.getUniqueId());
        this.packetBlockManager.getBlocksByMetadata(this.createStructureIdMetadataKey(structureId)).forEach(block -> block.removeViewer(player));
        this.getStructure(structureId).ifPresent(structure -> this.animationManager.getAnimation(structure.getDisappearAnimationId()).ifPresent(structureAnimation -> structureAnimation.onActivate(ContextBuilder.create().with(player).with(StructureContextKeys.STRUCTURE, structure).with(StructureContextKeys.ANIMATION_TYPE, StructureAnimation.Type.HIDE).build())));
        return true;
    }

    public Set<UUID> getViewers(@NonNull String structureId) {
        if (structureId == null) {
            throw new NullPointerException("structureId is marked non-null but is null");
        }
        return new HashSet<UUID>(this.structureViewers.getOrDefault(structureId, Set.of()));
    }

    @Generated
    public Map<String, Structure> getStructures() {
        return this.structures;
    }

    @Generated
    public Map<String, Set<UUID>> getStructureViewers() {
        return this.structureViewers;
    }

    @Generated
    public Map<UUID, String> getEditorMode() {
        return this.editorMode;
    }

    @Generated
    public Map<UUID, List<Location>> getEditorModeLocations() {
        return this.editorModeLocations;
    }

    @Generated
    public Structures getPlugin() {
        return this.plugin;
    }

    @Generated
    public StructureAnimationManager getAnimationManager() {
        return this.animationManager;
    }

    @Generated
    public PacketBlockManager getPacketBlockManager() {
        return this.packetBlockManager;
    }
}

