/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.trigger.Trigger;
import net.bitbylogic.structures.structure.StructureConfigSerializer;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Structure {
    private static final StructureConfigSerializer CONFIG_PARSER = new StructureConfigSerializer();
    private final String id;
    private final Map<Location, BlockData> blocks;
    private final List<Trigger> showTriggers;
    private final List<Trigger> hideTriggers;
    private final List<Predicate<Player>> showConditions;
    private final List<Predicate<Player>> hideConditions;
    @Nullable
    private String appearAnimationId;
    @Nullable
    private String disappearAnimationId;
    private final boolean requireTrigger;

    public Structure(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.blocks = new HashMap<Location, BlockData>();
        this.showTriggers = new ArrayList<Trigger>();
        this.hideTriggers = new ArrayList<Trigger>();
        this.showConditions = new ArrayList<Predicate<Player>>();
        this.hideConditions = new ArrayList<Predicate<Player>>();
        this.appearAnimationId = null;
        this.disappearAnimationId = null;
        this.requireTrigger = false;
    }

    public static StructureConfigSerializer getConfigParser() {
        return CONFIG_PARSER;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Map<Location, BlockData> getBlocks() {
        return this.blocks;
    }

    @Generated
    public List<Trigger> getShowTriggers() {
        return this.showTriggers;
    }

    @Generated
    public List<Trigger> getHideTriggers() {
        return this.hideTriggers;
    }

    @Generated
    public List<Predicate<Player>> getShowConditions() {
        return this.showConditions;
    }

    @Generated
    public List<Predicate<Player>> getHideConditions() {
        return this.hideConditions;
    }

    @Nullable
    @Generated
    public String getAppearAnimationId() {
        return this.appearAnimationId;
    }

    @Nullable
    @Generated
    public String getDisappearAnimationId() {
        return this.disappearAnimationId;
    }

    @Generated
    public boolean isRequireTrigger() {
        return this.requireTrigger;
    }

    @Generated
    public Structure(String id, Map<Location, BlockData> blocks, List<Trigger> showTriggers, List<Trigger> hideTriggers, List<Predicate<Player>> showConditions, List<Predicate<Player>> hideConditions, @Nullable String appearAnimationId, @Nullable String disappearAnimationId, boolean requireTrigger) {
        this.id = id;
        this.blocks = blocks;
        this.showTriggers = showTriggers;
        this.hideTriggers = hideTriggers;
        this.showConditions = showConditions;
        this.hideConditions = hideConditions;
        this.appearAnimationId = appearAnimationId;
        this.disappearAnimationId = disappearAnimationId;
        this.requireTrigger = requireTrigger;
    }

    @Generated
    public Structure(String id, Map<Location, BlockData> blocks, List<Trigger> showTriggers, List<Trigger> hideTriggers, List<Predicate<Player>> showConditions, List<Predicate<Player>> hideConditions, boolean requireTrigger) {
        this.id = id;
        this.blocks = blocks;
        this.showTriggers = showTriggers;
        this.hideTriggers = hideTriggers;
        this.showConditions = showConditions;
        this.hideConditions = hideConditions;
        this.requireTrigger = requireTrigger;
    }

    @Generated
    public void setAppearAnimationId(@Nullable String appearAnimationId) {
        this.appearAnimationId = appearAnimationId;
    }

    @Generated
    public void setDisappearAnimationId(@Nullable String disappearAnimationId) {
        this.disappearAnimationId = disappearAnimationId;
    }
}

