/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.structures.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;
import net.bitbylogic.structures.lib.bitsutils.condition.ConditionParser;
import net.bitbylogic.structures.lib.bitsutils.condition.parsed.ParsedCondition;
import net.bitbylogic.structures.lib.bitsutils.config.ConfigSerializer;
import net.bitbylogic.structures.lib.bitsutils.context.ContextBuilder;
import net.bitbylogic.structures.lib.bitsutils.location.LocationUtil;
import net.bitbylogic.structures.lib.bitsutils.trigger.Trigger;
import net.bitbylogic.structures.lib.bitsutils.trigger.TriggerParser;
import net.bitbylogic.structures.structure.Structure;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class StructureConfigSerializer
implements ConfigSerializer<Structure> {
    @Override
    public Optional<Structure> serializeFrom(@NonNull ConfigurationSection section) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        String id = section.getName();
        HashMap<Location, BlockData> blocks = new HashMap<Location, BlockData>();
        section.getStringList("Blocks").forEach(savedBlockData -> {
            String[] splitData = savedBlockData.split(";");
            Location location = LocationUtil.stringToLocation(splitData[0]);
            BlockData blockData = Bukkit.createBlockData((String)splitData[1]);
            blocks.put(location, blockData);
        });
        List<Trigger> showTriggers = TriggerParser.loadTriggers(section.getConfigurationSection("Show-Triggers"));
        List<Trigger> hideTriggers = TriggerParser.loadTriggers(section.getConfigurationSection("Hide-Triggers"));
        List<ParsedCondition> showConditions = ConditionParser.loadConditions(section.getConfigurationSection("Show-Conditions"));
        List<ParsedCondition> hideConditions = ConditionParser.loadConditions(section.getConfigurationSection("Hide-Conditions"));
        ArrayList<Predicate<Player>> showPredicates = new ArrayList<Predicate<Player>>();
        ArrayList<Predicate<Player>> hidePredicates = new ArrayList<Predicate<Player>>();
        showConditions.forEach(parsedCondition -> showPredicates.add(player -> parsedCondition.matches(ContextBuilder.create().with((Player)player).build())));
        hideConditions.forEach(parsedCondition -> hidePredicates.add(player -> parsedCondition.matches(ContextBuilder.create().with((Player)player).build())));
        String appearAnimationId = section.getString("Appear-Animation");
        String disappearAnimationId = section.getString("Disappear-Animation");
        boolean requireTrigger = section.getBoolean("Require-Trigger", false);
        return Optional.of(new Structure(id, blocks, showTriggers, hideTriggers, showPredicates, hidePredicates, appearAnimationId, disappearAnimationId, requireTrigger));
    }

    @Override
    public ConfigurationSection serializeTo(@NonNull ConfigurationSection section, @NonNull Structure structure) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (structure == null) {
            throw new NullPointerException("structure is marked non-null but is null");
        }
        ConfigurationSection structureSection = section.createSection(structure.getId());
        ArrayList blocks = new ArrayList();
        structure.getBlocks().forEach((location, blockData) -> blocks.add(LocationUtil.locationToString(location) + ";" + blockData.getAsString()));
        structureSection.set("Blocks", blocks);
        structureSection.set("Show-Triggers", structure.getShowTriggers().stream().map(Trigger::getId).toList());
        structureSection.set("Hide-Triggers", structure.getHideTriggers().stream().map(Trigger::getId).toList());
        structureSection.set("Appear-Animation", (Object)structure.getAppearAnimationId());
        structureSection.set("Disappear-Animation", (Object)structure.getDisappearAnimationId());
        return structureSection;
    }
}

