/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.tropicraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;

public class TikiTorchBlock
extends TemplateBlock {
    public static final EnumProperty<TikiTorchPart> TIKI_TORCH_PART = EnumProperty.of((String)"part", TikiTorchPart.class);

    public TikiTorchBlock(Identifier identifier) {
        super(identifier, class_15.field_982);
        this.method_1578(0.4375f, 0.0f, 0.4375f, 0.5625f, 1.0f, 0.5625f);
        this.method_1584(true);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_1617(class_18 world, int x, int y, int z, Random random) {
        if (world.getBlockState(x, y, z).get(TIKI_TORCH_PART) == TikiTorchPart.UPPER) {
            world.method_178("smoke", (double)x + 0.5, (double)y + 0.7, (double)z + 0.5, 0.0, 0.0, 0.0);
            world.method_178("flame", (double)x + 0.5, (double)y + 0.7, (double)z + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{TIKI_TORCH_PART});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)this.getDefaultState().with(TIKI_TORCH_PART, (Comparable)((Object)TikiTorchPart.LOWER));
    }

    public void method_1611(class_18 world, int x, int y, int z) {
        if (!world.getBlockState(x, y + 1, z).isAir() || !world.getBlockState(x, y + 2, z).isAir()) {
            return;
        }
        if (world.getBlockState(x, y, z).get(TIKI_TORCH_PART) == TikiTorchPart.LOWER) {
            world.setBlockState(x, y + 1, z, (BlockState)this.getDefaultState().with(TIKI_TORCH_PART, (Comparable)((Object)TikiTorchPart.MIDDLE)));
            world.setBlockState(x, y + 2, z, (BlockState)this.getDefaultState().with(TIKI_TORCH_PART, (Comparable)((Object)TikiTorchPart.UPPER)));
        }
    }

    public boolean method_1561(class_18 world, int x, int y, int z, int side) {
        return world.getBlockState(x, y + 1, z).isAir() && world.getBlockState(x, y + 2, z).isAir();
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        this.checkValidPlacement(world, x, y, z);
    }

    protected void checkValidPlacement(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        switch ((TikiTorchPart)((Object)state.get(TIKI_TORCH_PART))) {
            case UPPER: {
                if (world.getBlockState(x, y - 1, z).isOf((class_17)this) && world.getBlockState(x, y - 1, z).get(TIKI_TORCH_PART) == TikiTorchPart.MIDDLE) break;
                this.method_1581(world, x, y, z, new class_31(this.asItem(), 1, 0));
                world.setBlockStateWithNotify(x, y, z, (BlockState)States.AIR.get());
                break;
            }
            case MIDDLE: {
                if (!world.getBlockState(x, y - 1, z).isOf((class_17)this) || world.getBlockState(x, y - 1, z).get(TIKI_TORCH_PART) != TikiTorchPart.LOWER) {
                    world.setBlockStateWithNotify(x, y, z, (BlockState)States.AIR.get());
                }
                if (world.getBlockState(x, y + 1, z).isOf((class_17)this) && world.getBlockState(x, y + 1, z).get(TIKI_TORCH_PART) == TikiTorchPart.UPPER) break;
                world.setBlockStateWithNotify(x, y, z, (BlockState)States.AIR.get());
                break;
            }
            case LOWER: {
                if (world.getBlockState(x, y + 1, z).isOf((class_17)this) && world.getBlockState(x, y + 1, z).get(TIKI_TORCH_PART) == TikiTorchPart.MIDDLE) break;
                world.setBlockStateWithNotify(x, y, z, (BlockState)States.AIR.get());
            }
        }
    }

    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return class_25.method_94((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
    }

    public List<class_31> getDropList(class_18 world, int x, int y, int z, BlockState state, int meta) {
        ArrayList<class_31> drops = new ArrayList<class_31>();
        if (state.get(TIKI_TORCH_PART) == TikiTorchPart.UPPER) {
            drops.add(new class_31((class_17)this, 1));
        }
        return drops;
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }

    public static enum TikiTorchPart implements StringIdentifiable
    {
        UPPER("upper"),
        MIDDLE("middle"),
        LOWER("lower");

        final String id;

        private TikiTorchPart(String id) {
            this.id = id;
        }

        public String asString() {
            return this.id;
        }
    }
}

