/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.reforgestone.compat.emi;

import com.iafenvoy.reforgestone.Static;
import com.iafenvoy.reforgestone.data.stone.StoneTypeData;
import com.iafenvoy.reforgestone.data.stone.StoneTypeRegistry;
import com.iafenvoy.reforgestone.util.RandomHelper;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ReforgeStoneRecipeHelper {
    private static final List<Item> ALL_WEAPONS = BuiltInRegistries.f_257033_.m_123024_().filter(x -> x instanceof SwordItem || x instanceof AxeItem).toList();

    public static void register(EmiRegistry registry) {
        if (Static.server == null) {
            return;
        }
        for (StoneTypeData data : Static.server.m_206579_().m_175515_(StoneTypeRegistry.REGISTRY_KEY)) {
            registry.addRecipe((EmiRecipe)new AnvilRecipe(data));
        }
    }

    private static class AnvilRecipe
    implements EmiRecipe {
        private final ResourceLocation id;
        private final StoneTypeData data;
        private final List<Item> targets;
        private final EmiIngredient ingredientsEmi;
        private final EmiIngredient targetsEmi;
        private final int unique = new Random().nextInt();
        private Item lastTarget = Items.f_41852_;

        private AnvilRecipe(StoneTypeData data) {
            this.id = ResourceLocation.m_214293_((String)"reforge_stone", (String)("/anvil/" + data.translate()));
            this.data = data;
            this.targets = data.listAllTargets();
            this.ingredientsEmi = EmiIngredient.of(data.listAllIngredients().stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).map(EmiIngredient::of).toList());
            this.targetsEmi = EmiIngredient.of(this.targets.stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).map(EmiIngredient::of).toList());
        }

        public EmiRecipeCategory getCategory() {
            return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return List.of(this.ingredientsEmi, this.targetsEmi);
        }

        public List<EmiStack> getOutputs() {
            return List.of(EmiStack.of((ItemLike)Items.f_41852_));
        }

        public boolean supportsRecipeTree() {
            return false;
        }

        public int getDisplayWidth() {
            return 125;
        }

        public int getDisplayHeight() {
            return 18;
        }

        public void addWidgets(WidgetHolder widgets) {
            widgets.addTexture(EmiTexture.PLUS, 27, 3);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
            widgets.addGeneratedSlot(r -> {
                ItemLike[] itemLikeArray = new ItemLike[1];
                this.lastTarget = RandomHelper.randomOne(r, this.targets);
                itemLikeArray[0] = this.lastTarget;
                return EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])itemLikeArray));
            }, this.unique, 0, 0);
            widgets.addSlot(this.ingredientsEmi, 49, 0);
            ItemStack stack = new ItemStack((ItemLike)this.lastTarget);
            StoneTypeRegistry.addModifiers(this.data, stack);
            widgets.addGeneratedSlot(r -> EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})), this.unique, 107, 0).recipeContext((EmiRecipe)this);
        }
    }
}

