/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.reforgestone.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.iafenvoy.reforgestone.data.modifier.Modifier;
import com.iafenvoy.reforgestone.data.modifier.builtin.AttributeModifier;
import com.iafenvoy.reforgestone.data.modifier.builtin.MaxDamageModifier;
import com.iafenvoy.reforgestone.data.modifier.builtin.NameModifier;
import com.iafenvoy.reforgestone.data.stone.StoneTypeRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Unique
    private ItemStack reforge_stone$self() {
        return (ItemStack)this;
    }

    @Inject(method={"getAttributeModifiers"}, at={@At(value="TAIL")}, cancellable=true)
    private void handleAttributes(EquipmentSlot slot, CallbackInfoReturnable<Multimap<Attribute, net.minecraft.world.entity.ai.attributes.AttributeModifier>> cir) {
        HashMultimap map = HashMultimap.create();
        map.putAll((Multimap)cir.getReturnValue());
        if (map.isEmpty()) {
            return;
        }
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(this.reforge_stone$self());
        for (Modifier<?> modifier : modifiers) {
            if (!(modifier instanceof AttributeModifier)) continue;
            AttributeModifier m = (AttributeModifier)modifier;
            map.put((Object)m.attribute(), (Object)new net.minecraft.world.entity.ai.attributes.AttributeModifier("Modifier", m.value(), m.operation()));
        }
        cir.setReturnValue((Object)map);
    }

    @Inject(method={"getName"}, at={@At(value="TAIL")}, cancellable=true)
    private void handleName(CallbackInfoReturnable<Component> cir) {
        Component text = (Component)cir.getReturnValue();
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(this.reforge_stone$self());
        for (Modifier<?> modifier : modifiers) {
            if (!(modifier instanceof NameModifier)) continue;
            NameModifier m = (NameModifier)modifier;
            text = Component.m_237115_((String)m.prefix()).m_7220_(text).m_7220_((Component)Component.m_237115_((String)m.suffix())).m_130948_(Style.f_131099_.m_178520_(m.color()));
        }
        cir.setReturnValue((Object)text);
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void handleMaxDamage(CallbackInfoReturnable<Integer> cir) {
        int value = (Integer)cir.getReturnValue();
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(this.reforge_stone$self());
        for (Modifier<?> modifier : modifiers) {
            if (!(modifier instanceof MaxDamageModifier)) continue;
            MaxDamageModifier m = (MaxDamageModifier)modifier;
            value += m.addition();
        }
        cir.setReturnValue((Object)value);
    }
}

