/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.reforgestone.render;

import com.iafenvoy.reforgestone.data.modifier.Modifier;
import com.iafenvoy.reforgestone.data.modifier.builtin.GlintModifier;
import com.iafenvoy.reforgestone.data.stone.StoneTypeRegistry;
import com.iafenvoy.reforgestone.render.GlintManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class GlintLayerManager
extends RenderType {
    private static final Map<GlintManager.GlintHolder, RenderType> DIRECT_LAYERS = new HashMap<GlintManager.GlintHolder, RenderType>();
    private static final Map<GlintManager.GlintHolder, RenderType> ARMOR_LAYERS = new HashMap<GlintManager.GlintHolder, RenderType>();

    public GlintLayerManager(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    @ApiStatus.Internal
    public static void registerAll(SortedMap<RenderType, BufferBuilder> map) {
        for (Map.Entry<GlintManager.GlintHolder, RenderType> entry : DIRECT_LAYERS.entrySet()) {
            if (map.containsKey(entry.getValue())) continue;
            map.put(entry.getValue(), new BufferBuilder(entry.getValue().m_110507_()));
        }
    }

    public static boolean shouldAlwaysGlint(ItemStack stack) {
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(stack);
        for (Modifier<?> modifier : modifiers) {
            GlintModifier m;
            if (!(modifier instanceof GlintModifier) || !(m = (GlintModifier)modifier).always()) continue;
            return true;
        }
        return !stack.m_41619_() && stack.m_41783_() != null && stack.m_41783_().m_128425_(GlintManager.GLINT_KEY, 8) && GlintManager.BY_ID.containsKey(stack.m_41784_().m_128461_(GlintManager.GLINT_KEY)) && stack.m_41783_().m_128471_(GlintManager.GLINT_ALWAYS_KEY);
    }

    public static RenderType processStack(RenderType origin, ItemStack stack) {
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(stack);
        for (Modifier<?> modifier : modifiers) {
            GlintModifier m;
            if (!(modifier instanceof GlintModifier) || !(m = (GlintModifier)modifier).always()) continue;
            return DIRECT_LAYERS.getOrDefault(GlintManager.BY_ID.getOrDefault(m.color(), GlintManager.DEFAULT), RenderType.m_110493_());
        }
        if (!stack.m_41619_() && stack.m_41783_() != null && stack.m_41783_().m_128425_(GlintManager.GLINT_KEY, 8)) {
            String id = stack.m_41784_().m_128461_(GlintManager.GLINT_KEY);
            if (stack.m_41783_().m_128471_(GlintManager.GLINT_ALWAYS_KEY)) {
                return DIRECT_LAYERS.getOrDefault(GlintManager.BY_ID.getOrDefault(id, GlintManager.DEFAULT), RenderType.m_110493_());
            }
        }
        return origin;
    }

    public static RenderType processArmor(RenderType origin, ItemStack stack) {
        List<Modifier<?>> modifiers = StoneTypeRegistry.getModifiers(stack);
        for (Modifier<?> modifier : modifiers) {
            GlintModifier m;
            if (!(modifier instanceof GlintModifier) || !(m = (GlintModifier)modifier).always()) continue;
            return ARMOR_LAYERS.getOrDefault(GlintManager.BY_ID.getOrDefault(m.color(), GlintManager.DEFAULT), RenderType.m_110493_());
        }
        if (!stack.m_41619_() && stack.m_41783_() != null && stack.m_41783_().m_128425_(GlintManager.GLINT_KEY, 8)) {
            String id = stack.m_41784_().m_128461_(GlintManager.GLINT_KEY);
            if (stack.m_41783_().m_128471_(GlintManager.GLINT_ALWAYS_KEY)) {
                return ARMOR_LAYERS.getOrDefault(GlintManager.BY_ID.getOrDefault(id, GlintManager.DEFAULT), RenderType.m_110493_());
            }
        }
        return origin;
    }

    static {
        for (GlintManager.GlintHolder holder : GlintManager.HOLDERS) {
            if (holder.texture() == null) continue;
            DIRECT_LAYERS.put(holder, (RenderType)RenderType.m_173209_((String)("direct_glint_" + holder.id()), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173082_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(holder.texture(), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110150_).m_110691_(false)));
            ARMOR_LAYERS.put(holder, (RenderType)RenderType.m_173209_((String)("armor_glint_" + holder.id()), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173079_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(holder.texture(), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110669_(f_110119_).m_110691_(false)));
        }
    }
}

