/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaw.marshlawscustomarmors.item;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import net.marshlaw.marshlawscustomarmors.init.MarshlawsCustomArmorsModItems;
import net.marshlaw.marshlawscustomarmors.procedures.RedStainedGlassArmorBootsTickEventProcedure;
import net.marshlaw.marshlawscustomarmors.procedures.RedStainedGlassArmorChestplateTickEventProcedure;
import net.marshlaw.marshlawscustomarmors.procedures.RedStainedGlassArmorHelmetTickEventProcedure;
import net.marshlaw.marshlawscustomarmors.procedures.RedStainedGlassArmorLeggingsTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class RedStainedGlassArmorItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(8, Map.of(ArmorType.BOOTS, 1, ArmorType.LEGGINGS, 3, ArmorType.CHESTPLATE, 3, ArmorType.HELMET, 1, ArmorType.BODY, 3), 5, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY), 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"marshlaws_custom_armors:red_stained_glass_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"marshlaws_custom_armors:red_stained_glass_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"marshlaws_custom_armors:textures/models/armor/red_stained_glass_layer_1.png");
            }
        }, new Item[]{(Item)MarshlawsCustomArmorsModItems.RED_STAINED_GLASS_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"marshlaws_custom_armors:textures/models/armor/red_stained_glass_layer_1.png");
            }
        }, new Item[]{(Item)MarshlawsCustomArmorsModItems.RED_STAINED_GLASS_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"marshlaws_custom_armors:textures/models/armor/red_stained_glass_layer_2.png");
            }
        }, new Item[]{(Item)MarshlawsCustomArmorsModItems.RED_STAINED_GLASS_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"marshlaws_custom_armors:textures/models/armor/red_stained_glass_layer_1.png");
            }
        }, new Item[]{(Item)MarshlawsCustomArmorsModItems.RED_STAINED_GLASS_ARMOR_BOOTS.get()});
    }

    private RedStainedGlassArmorItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends RedStainedGlassArmorItem {
        public Boots(Item.Properties properties) {
            super(ArmorType.BOOTS, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.marshlaws_custom_armors.red_stained_glass_armor_boots.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                RedStainedGlassArmorBootsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends RedStainedGlassArmorItem {
        public Leggings(Item.Properties properties) {
            super(ArmorType.LEGGINGS, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.marshlaws_custom_armors.red_stained_glass_armor_leggings.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                RedStainedGlassArmorLeggingsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Chestplate
    extends RedStainedGlassArmorItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.marshlaws_custom_armors.red_stained_glass_armor_chestplate.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                RedStainedGlassArmorChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends RedStainedGlassArmorItem {
        public Helmet(Item.Properties properties) {
            super(ArmorType.HELMET, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.marshlaws_custom_armors.red_stained_glass_armor_helmet.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                RedStainedGlassArmorHelmetTickEventProcedure.execute(entity);
            }
        }
    }
}

