/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaw.marshlawscustomarmors.item;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.marshlaw.marshlawscustomarmors.procedures.ImmortalProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;

public abstract class BedrockArmorItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(15, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 5, ArmorType.CHESTPLATE, 6, ArmorType.HELMET, 2, ArmorType.BODY, 6), 9, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY), 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"marshlaws_custom_armors:bedrock_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"marshlaws_custom_armors:bedrock_armor")));

    private BedrockArmorItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends BedrockArmorItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.marshlaws_custom_armors.bedrock_armor_boots.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    ImmortalProcedure.execute(entity);
                }
            }
        }
    }

    public static class Leggings
    extends BedrockArmorItem {
        public Leggings(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.marshlaws_custom_armors.bedrock_armor_leggings.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    ImmortalProcedure.execute(entity);
                }
            }
        }
    }

    public static class Chestplate
    extends BedrockArmorItem {
        public Chestplate(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.marshlaws_custom_armors.bedrock_armor_chestplate.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    ImmortalProcedure.execute(entity);
                }
            }
        }
    }

    public static class Helmet
    extends BedrockArmorItem {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.marshlaws_custom_armors.bedrock_armor_helmet.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    ImmortalProcedure.execute(entity);
                }
            }
        }
    }
}

