/*
 * Decompiled with CFR 0.152.
 */
package dev.chachy.lazylanguageloader.client.mixin.ui.searchbar;

import dev.chachy.lazylanguageloader.client.api.scroll.Scrollable;
import dev.chachy.lazylanguageloader.client.impl.state.StateManager;
import dev.chachy.lazylanguageloader.client.mixin.ui.searchbar.accessor.EntryListWidgetAccessor;
import dev.chachy.lazylanguageloader.client.mixin.ui.searchbar.accessor.LanguageEntryAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.option.LanguageOptionsScreen;
import net.minecraft.client.gui.widget.ClickableWidget;
import net.minecraft.client.gui.widget.EntryListWidget;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageOptionsScreen.class})
public class MixinLanguageOptionsScreen
extends Screen {
    @Shadow
    private LanguageOptionsScreen.LanguageSelectionListWidget languageSelectionList;
    @Unique
    private List<LanguageOptionsScreen.LanguageSelectionListWidget.LanguageEntry> initialComponents;
    @Unique
    private TextFieldWidget searchText;

    protected MixinLanguageOptionsScreen(Text title) {
        super(title);
    }

    @Inject(method={"initFooter"}, at={@At(value="TAIL")})
    private void lazyLanguageLoader$$init(CallbackInfo ci) {
        this.initialComponents = new ArrayList<LanguageOptionsScreen.LanguageSelectionListWidget.LanguageEntry>(this.languageSelectionList.children());
        int w = this.width / 5;
        this.searchText = new TextFieldWidget(this.textRenderer, this.width - (w + 5), 11, w, 15, (Text)Text.empty());
        this.searchText.setSuggestion(this.lazyLanguageLoader$$truncateByWidth("Search for a language", (ClickableWidget)this.searchText, "..."));
        this.searchText.setChangedListener(this::lazyLanguageLoader$$handleText);
        this.addDrawableChild((Element)this.searchText);
    }

    @Unique
    private void lazyLanguageLoader$$handleText(String text) {
        List children = this.languageSelectionList.children();
        if (text.isBlank()) {
            int currentSize;
            int initialSize = this.initialComponents.size();
            if (initialSize != (currentSize = children.size())) {
                this.languageSelectionList.replaceEntries(this.initialComponents);
            }
            this.searchText.setSuggestion(this.lazyLanguageLoader$$truncateByWidth("Search for a language", (ClickableWidget)this.searchText, "..."));
        } else {
            this.searchText.setSuggestion("");
            for (LanguageOptionsScreen.LanguageSelectionListWidget.LanguageEntry entry : this.initialComponents) {
                Text def = ((LanguageEntryAccessor)entry).getLanguageDefinition();
                if (StateManager.isMatchable(text, def)) {
                    this.lazyLanguageLoader$$safeAdd(entry);
                    continue;
                }
                this.languageSelectionList.removeEntry((EntryListWidget.Entry)entry);
            }
        }
        this.lazyLanguageLoader$$fixScroll();
    }

    @Unique
    private void lazyLanguageLoader$$fixScroll() {
        if (((Scrollable)this.languageSelectionList).hasScrolled()) {
            ((EntryListWidgetAccessor)this.languageSelectionList).invokeScroll((int)this.languageSelectionList.getScrollY());
        } else {
            this.languageSelectionList.centerScrollOn((EntryListWidget.Entry)((LanguageOptionsScreen.LanguageSelectionListWidget.LanguageEntry)this.languageSelectionList.getSelectedOrNull()));
        }
    }

    @Unique
    private void lazyLanguageLoader$$safeAdd(LanguageOptionsScreen.LanguageSelectionListWidget.LanguageEntry entry) {
        if (!this.languageSelectionList.children().contains(entry)) {
            this.languageSelectionList.addEntry((EntryListWidget.Entry)entry);
        }
    }

    @Unique
    private String lazyLanguageLoader$$truncateByWidth(String text, ClickableWidget widget, String marker) {
        int widgetWidth;
        int textWidth = this.textRenderer.getWidth(text);
        if (textWidth > (widgetWidth = widget.getWidth())) {
            String truncatedText = text;
            int truncatedWidth = textWidth;
            while (truncatedWidth > widgetWidth) {
                truncatedText = truncatedText.substring(0, truncatedText.length() - 1);
                truncatedWidth = this.textRenderer.getWidth(truncatedText);
            }
            return this.lazyLanguageLoader$$addTruncationMarker(truncatedText, marker);
        }
        return text;
    }

    @Unique
    private String lazyLanguageLoader$$addTruncationMarker(String text, String marker) {
        return text.length() > marker.length() ? text.substring(0, text.length() - marker.length()) : marker;
    }
}

