package dev.chachy.lazylanguageloader.client.mixin.ui.searchbar;

import dev.chachy.lazylanguageloader.client.api.scroll.Scrollable;
import dev.chachy.lazylanguageloader.client.impl.state.StateManager;
import dev.chachy.lazylanguageloader.client.impl.utils.Constants;
import dev.chachy.lazylanguageloader.client.mixin.ui.searchbar.accessor.EntryListWidgetAccessor;
import dev.chachy.lazylanguageloader.client.mixin.ui.searchbar.accessor.LanguageEntryAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_426;
import net.minecraft.class_437;

@Mixin(class_426.class)
public class MixinLanguageOptionsScreen extends class_437 {
    @Shadow
    private class_426.class_4195 languageSelectionList;

    @Unique
    private List<class_426.class_4195.class_4194> initialComponents;

    @Unique
    private class_342 searchText;

    protected MixinLanguageOptionsScreen(class_2561 title) {
        super(title);
    }

    @Inject(method = "initFooter", at = @At("TAIL"))
    private void lazyLanguageLoader$$init(CallbackInfo ci) {
        initialComponents = new ArrayList<>(languageSelectionList.method_25396());

        int w = field_22789 / 5;

        searchText = new class_342(field_22793, field_22789 - (w + 5), 11, w, 15, class_2561.method_43473());

        searchText.method_1887(lazyLanguageLoader$$truncateByWidth(Constants.SUGGESTION_TEXT, searchText, Constants.TRUNCATION_MARKER));
        searchText.method_1863(this::lazyLanguageLoader$$handleText);

        method_37063(searchText);
    }

    @Unique
    private void lazyLanguageLoader$$handleText(String text) {
        List<class_426.class_4195.class_4194> children = languageSelectionList.method_25396();

        if (text.isBlank()) {
            int initialSize = initialComponents.size();
            int currentSize = children.size();

            if (initialSize != currentSize) {
                languageSelectionList.method_25314(initialComponents);
            }

            searchText.method_1887(lazyLanguageLoader$$truncateByWidth(Constants.SUGGESTION_TEXT, searchText, Constants.TRUNCATION_MARKER));
        } else {
            searchText.method_1887(Constants.EMPTY_TEXT);
            for (class_426.class_4195.class_4194 entry : initialComponents) {
                class_2561 def = ((LanguageEntryAccessor) entry).getLanguageDefinition();

                if (StateManager.isMatchable(text, def)) {
                    lazyLanguageLoader$$safeAdd(entry);
                } else {
                    languageSelectionList.method_25330(entry);
                }
            }
        }
        lazyLanguageLoader$$fixScroll();
    }

    @Unique
    private void lazyLanguageLoader$$fixScroll() {
        if (((Scrollable) languageSelectionList).hasScrolled()) {
            ((EntryListWidgetAccessor) languageSelectionList).invokeScroll((int) languageSelectionList.method_44387());
        } else {
            languageSelectionList.method_25324(languageSelectionList.method_25334());
        }
    }

    @Unique
    private void lazyLanguageLoader$$safeAdd(class_426.class_4195.class_4194 entry) {
        if (!languageSelectionList.method_25396().contains(entry)) {
            languageSelectionList.method_25321(entry);
        }
    }

    @Unique
    private String lazyLanguageLoader$$truncateByWidth(String text, class_339 widget, String marker) {
        int textWidth = field_22793.method_1727(text);
        int widgetWidth = widget.method_25368();

        if (textWidth > widgetWidth) {
            String truncatedText = text;
            int truncatedWidth = textWidth;

            while (truncatedWidth > widgetWidth) {
                truncatedText = truncatedText.substring(0, truncatedText.length() - 1);
                truncatedWidth = field_22793.method_1727(truncatedText);
            }

            return lazyLanguageLoader$$addTruncationMarker(truncatedText, marker);
        } else {
            return text;
        }
    }

    @Unique
    private String lazyLanguageLoader$$addTruncationMarker(String text, String marker) {
        return text.length() > marker.length() ? text.substring(0, text.length() - marker.length()) : marker;
    }
}
