/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltbpvp.client.gui;

import java.lang.reflect.Field;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import pl.lordtricker.ltbpvp.client.config.ModSettings;
import pl.lordtricker.ltbpvp.client.enums.SwingStyle;

@Environment(value=EnvType.CLIENT)
public class AnimationEditorScreen
extends class_437 {
    private final class_437 parentScreen;
    private class_4185 swingStyleButton;
    private OffsetSliderWidget sliderX;
    private OffsetSliderWidget sliderY;
    private OffsetSliderWidget sliderZ;
    private class_4185 resetButton;
    private class_4185 saveButton;
    private final int totalLines = 5;
    private final int rowSpacing = 25;
    private final int widgetWidth = 150;
    private final int widgetHeight = 20;
    private int startY;

    public AnimationEditorScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)"Edit - Sword Animation"));
        this.parentScreen = parentScreen;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int totalBlockHeight = 125;
        int line1Y = this.startY = (this.field_22790 - totalBlockHeight) / 2;
        this.swingStyleButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)("Style: " + this.getSwingStyleDisplay(ModSettings.swingStyle))), btn -> {
            ModSettings.swingStyle = this.getNextSwingStyle(ModSettings.swingStyle);
            btn.method_25355(class_2561.method_30163((String)("Style: " + this.getSwingStyleDisplay(ModSettings.swingStyle))));
            this.refreshSliders();
        }).method_46434(centerX - 75, line1Y, 150, 20).method_46431();
        this.method_37063((class_364)this.swingStyleButton);
        ModSettings.AnimationOffsets offsets = ModSettings.styleOffsets.get((Object)ModSettings.swingStyle);
        int line2Y = this.startY + 25;
        this.sliderX = this.createOffsetSlider("X", offsets.offsetX, centerX - 75, line2Y, 150, 20);
        this.method_37063((class_364)this.sliderX);
        int line3Y = this.startY + 50;
        this.sliderY = this.createOffsetSlider("Y", offsets.offsetY, centerX - 75, line3Y, 150, 20);
        this.method_37063((class_364)this.sliderY);
        int line4Y = this.startY + 75;
        this.sliderZ = this.createOffsetSlider("Z", offsets.offsetZ, centerX - 75, line4Y, 150, 20);
        this.method_37063((class_364)this.sliderZ);
        int line5Y = this.startY + 100;
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Reset"), btn -> {
            offsets.offsetX = 0.0f;
            offsets.offsetY = 0.0f;
            offsets.offsetZ = 0.0f;
            this.sliderX.setSliderValue(this.normalizeOffset(offsets.offsetX));
            this.sliderY.setSliderValue(this.normalizeOffset(offsets.offsetY));
            this.sliderZ.setSliderValue(this.normalizeOffset(offsets.offsetZ));
        }).method_46434(centerX - 75, line5Y + 5, 150, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        int saveBtnWidth = 100;
        int saveBtnX = centerX - saveBtnWidth / 2;
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Save"), btn -> this.field_22787.method_1507(this.parentScreen)).method_46434(saveBtnX, this.field_22790 - 30, saveBtnWidth, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
    }

    private void refreshSliders() {
        ModSettings.AnimationOffsets off = ModSettings.styleOffsets.get((Object)ModSettings.swingStyle);
        this.sliderX.setSliderValue(this.normalizeOffset(off.offsetX));
        this.sliderY.setSliderValue(this.normalizeOffset(off.offsetY));
        this.sliderZ.setSliderValue(this.normalizeOffset(off.offsetZ));
    }

    private OffsetSliderWidget createOffsetSlider(String axis, float initial, int x, int y, int w, int h) {
        double val = this.normalizeOffset(initial);
        return new OffsetSliderWidget(this, x, y, w, h, (class_2561)class_2561.method_43470((String)(axis + ": " + String.format("%.2f", Float.valueOf(initial)))), val, axis);
    }

    private double normalizeOffset(float off) {
        double sliderVal = ((double)off + 2.0) / 4.0;
        if (sliderVal < 0.0) {
            sliderVal = 0.0;
        }
        if (sliderVal > 1.0) {
            sliderVal = 1.0;
        }
        return sliderVal;
    }

    private float denormalizeOffset(double sliderVal) {
        return (float)(sliderVal * 4.0 - 2.0);
    }

    private String getSwingStyleDisplay(SwingStyle style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case SwingStyle.BASIC_SWING -> "BASIC";
            case SwingStyle.BASIC_CLAP -> "BASIC_CLAP";
            case SwingStyle.SWIPE_IN -> "SWIPE_IN";
            case SwingStyle.SWIPE_OUT -> "SWIPE_OUT";
            case SwingStyle.NO_SWING -> "NO_SWING";
        };
    }

    private SwingStyle getNextSwingStyle(SwingStyle current) {
        SwingStyle[] all = SwingStyle.values();
        int index = (current.ordinal() + 1) % all.length;
        return all[index];
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawCenteredTextLocal(context, this.field_22785, 10, 0xFFFFFF);
    }

    private void drawCenteredTextLocal(class_332 context, class_2561 text, int y, int color) {
        int textWidth = this.field_22793.method_27525((class_5348)text);
        int x = (this.field_22789 - textWidth) / 2;
        context.method_51439(this.field_22793, text, x, y, color, false);
    }

    @Environment(value=EnvType.CLIENT)
    private class OffsetSliderWidget
    extends class_357 {
        private final String axis;
        private double customValue;

        public OffsetSliderWidget(AnimationEditorScreen animationEditorScreen, int x, int y, int width, int height, class_2561 message, double value, String axis) {
            super(x, y, width, height, message, value);
            this.axis = axis;
            this.customValue = value;
        }

        public double getSliderValue() {
            return this.customValue;
        }

        public void setSliderValue(double newValue) {
            this.customValue = newValue;
            try {
                Field field = class_357.class.getDeclaredField("value");
                field.setAccessible(true);
                field.set((Object)this, newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.method_25346();
        }

        protected void method_25346() {
            float offVal = (float)(this.customValue * 4.0 - 2.0);
            this.method_25355((class_2561)class_2561.method_43470((String)(this.axis + ": " + String.format("%.2f", Float.valueOf(offVal)))));
        }

        protected void method_25344() {
            this.customValue = this.field_22753;
            this.method_25346();
            ModSettings.AnimationOffsets off = ModSettings.styleOffsets.get((Object)ModSettings.swingStyle);
            float realVal = (float)(this.customValue * 4.0 - 2.0);
            switch (this.axis) {
                case "X": {
                    off.offsetX = realVal;
                    break;
                }
                case "Y": {
                    off.offsetY = realVal;
                    break;
                }
                case "Z": {
                    off.offsetZ = realVal;
                }
            }
        }
    }
}

