/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltbpvp.client.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pl.lordtricker.ltbpvp.client.config.ModSettings;
import pl.lordtricker.ltbpvp.client.hud.AttackDelayTutorHUD;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_746.class})
public abstract class AttackDelayTutorMixin {
    @Unique
    private long lastSwingTime = 0L;
    @Unique
    private boolean hasAttackedOnce = false;

    @Inject(method={"swingHand"}, at={@At(value="HEAD")})
    private void onSwingHand(class_1268 hand, CallbackInfo ci) {
        if (!ModSettings.attackDelayTutorEnabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (!this.hasAttackedOnce) {
            this.hasAttackedOnce = true;
            this.lastSwingTime = currentTime;
            return;
        }
        long delta = currentTime - this.lastSwingTime;
        this.lastSwingTime = currentTime;
        class_746 player = (class_746)this;
        float attackSpeed = (float)player.method_26825(class_5134.field_23723);
        float cooldownTicks = 20.0f / attackSpeed;
        long cooldownMs = (long)(cooldownTicks * 50.0f);
        class_239 hit = class_310.method_1551().field_1765;
        if (hit instanceof class_3966 && delta < cooldownMs) {
            if (ModSettings.attackDelayTutorTextEnabled) {
                AttackDelayTutorHUD.setMessage("Uderzy\u0142e\u015b za szybko!", 500L);
            }
            if (ModSettings.attackDelayTutorSoundEnabled) {
                player.method_5783(class_3417.field_14785, 0.15f, 1.0f);
            }
        }
    }
}

