/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltbpvp.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import pl.lordtricker.ltbpvp.client.config.Config;

@Environment(value=EnvType.CLIENT)
public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String MAIN_CONFIG_FILE_NAME = "ltbetterpvp-config.json";
    private static final Path MOD_CONFIG_DIR;

    public static Config loadConfig() {
        Config config;
        block9: {
            Path configFile = MOD_CONFIG_DIR.resolve(MAIN_CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                Config defaultCfg = ConfigLoader.createDefaultConfig();
                ConfigLoader.saveConfig(defaultCfg);
                return defaultCfg;
            }
            BufferedReader reader = Files.newBufferedReader(configFile);
            try {
                Config cfg = (Config)GSON.fromJson((Reader)reader, Config.class);
                Config config2 = config = cfg != null ? cfg : ConfigLoader.createDefaultConfig();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return ConfigLoader.createDefaultConfig();
                }
            }
            ((Reader)reader).close();
        }
        return config;
    }

    public static void saveConfig(Config cfg) {
        Path configFile = MOD_CONFIG_DIR.resolve(MAIN_CONFIG_FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)cfg, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Config createDefaultConfig() {
        return new Config();
    }

    static {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        MOD_CONFIG_DIR = configDir.resolve("LT-Mods").resolve("LT-BetterPVP");
        try {
            if (!Files.exists(MOD_CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(MOD_CONFIG_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

