/*
 * Decompiled with CFR 0.152.
 */
package me.alini.simplelocks.event;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.alini.simplelocks.item.lock;
import me.alini.simplelocks.util.LockCacheUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class LockBreakEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockEntity be = event.getLevel().m_7702_(event.getPos());
        if (be == null) {
            return;
        }
        List<ItemStack> allItems = this.getAllItems(be);
        boolean hasAnyLock = false;
        for (ItemStack stack : allItems) {
            UUID owner;
            if (stack.m_41619_() || !lock.LOCK_ITEM.isPresent() || stack.m_41720_() != lock.LOCK_ITEM.get()) continue;
            hasAnyLock = true;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128403_("Owner") || !(owner = tag.m_128342_("Owner")).equals(player2.m_20148_()) && !player2.m_20310_(4)) continue;
            LockCacheUtil.removeLockSnapshot(be);
            return;
        }
        if (hasAnyLock) {
            event.setCanceled(true);
            player2.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u6b64\u5bb9\u5668\u5df2\u4e0a\u9501\uff0c\u65e0\u6cd5\u7834\u574f\uff01"));
            MinecraftServer server = player2.m_20194_();
            if (server != null) {
                BlockPos pos = event.getPos();
                Level level = (Level)event.getLevel();
                ResourceLocation dim = level.m_46472_().m_135782_();
                String msg = String.format("\u00a76%s \u00a7c\u8bd5\u56fe\u7834\u574f\u4ed6\u4eba\u9501\u5b9a\u7684\u5bb9\u5668\uff01\u00a7b\u4f4d\u7f6e: %s %d %d %d", player2.m_7755_().getString(), dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                server.m_6846_().m_240416_((Component)Component.m_237113_((String)msg), false);
            }
        } else {
            LockCacheUtil.updateLockSnapshot(be);
        }
    }

    private List<ItemStack> getAllItems(BlockEntity be) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                items.add(container.m_8020_(i));
            }
        }
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                items.add(handler.getStackInSlot(i));
            }
        });
        if (items.isEmpty()) {
            items.addAll(this.getItemsFromCustomBlockEntity(be));
        }
        return items;
    }

    private List<ItemStack> getItemsFromCustomBlockEntity(BlockEntity be) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try {
            Field[] fields;
            for (Field field : fields = be.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(be);
                if (value instanceof ItemStack) {
                    ItemStack stack = (ItemStack)value;
                    items.add(stack);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object obj : list) {
                        if (!(obj instanceof ItemStack)) continue;
                        ItemStack stack = (ItemStack)obj;
                        items.add(stack);
                    }
                    continue;
                }
                if (value instanceof ItemStackHandler) {
                    ItemStackHandler handler = (ItemStackHandler)value;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        items.add(handler.getStackInSlot(i));
                    }
                    continue;
                }
                if (!(value instanceof IItemHandler)) continue;
                IItemHandler handler = (IItemHandler)value;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    items.add(handler.getStackInSlot(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items;
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close event) {
        MenuType type;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu menu = event.getContainer();
        try {
            type = menu.m_6772_();
        }
        catch (RuntimeException ignored) {
            return;
        }
        if (type != MenuType.f_39959_) {
            return;
        }
        if (menu.f_38839_.isEmpty()) {
            return;
        }
        try {
            if (player2.m_36327_() != ((Slot)menu.f_38839_.get((int)0)).f_40218_) {
                return;
            }
        }
        catch (RuntimeException ignored) {
            return;
        }
        boolean returned = false;
        for (Slot slot : menu.f_38839_) {
            ItemStack stack;
            if (slot.f_40218_ != player2.m_36327_() || (stack = slot.m_7993_()).m_41619_() || !lock.LOCK_ITEM.isPresent() || stack.m_41720_() != lock.LOCK_ITEM.get()) continue;
            ItemStack lockCopy = stack.m_41777_();
            boolean added = player2.m_150109_().m_36054_(lockCopy);
            if (!added) {
                player2.m_36176_(lockCopy, false);
            }
            slot.m_5852_(ItemStack.f_41583_);
            returned = true;
        }
        if (returned) {
            player2.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u9501\u65e0\u6cd5\u653e\u5165\u672b\u5f71\u7bb1\uff0c\u5df2\u8fd4\u8fd8\u7ed9\u4f60\uff01"), true);
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new LockBreakEventHandler());
    }
}

