/*
 * Decompiled with CFR 0.152.
 */
package me.alini.simplelocks.mixin;

import me.alini.simplelocks.item.lock;
import me.alini.simplelocks.util.LockCacheUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class ServerGamePacketListenerImplMixin {
    @Inject(method={"handleContainerClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkPermissions(ServerboundContainerClickPacket packet, CallbackInfo ci) {
        ServerPlayer player = ((ServerGamePacketListenerImpl)this).f_9743_;
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return;
        }
        if (menu instanceof InventoryMenu || menu.f_38839_.isEmpty() || menu instanceof CraftingMenu) {
            return;
        }
        Container container = menu.m_38853_((int)0).f_40218_;
        boolean hasMyLock = false;
        boolean hasAnyLock = false;
        if (lock.LOCK_ITEM.isPresent()) {
            for (Slot slot : menu.f_38839_) {
                CompoundTag tag;
                ItemStack stack;
                if (slot.f_40218_ != container || (stack = slot.m_7993_()).m_41619_() || stack.m_41720_() != lock.LOCK_ITEM.get() || (tag = stack.m_41783_()) == null || !tag.m_128403_("Owner")) continue;
                hasAnyLock = true;
                if (!tag.m_128342_("Owner").equals(player.m_20148_())) continue;
                hasMyLock = true;
                break;
            }
        }
        if (hasAnyLock && !hasMyLock && !player.m_20310_(4)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u5bb9\u5668\u91cc\u7684\u7269\u54c1\uff01"), true);
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerClick"}, at={@At(value="TAIL")})
    private void refreshSnapshotAfterClick(ServerboundContainerClickPacket packet, CallbackInfo ci) {
        ServerPlayer player = ((ServerGamePacketListenerImpl)this).f_9743_;
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null || menu.f_38839_.isEmpty()) {
            return;
        }
        Container container = menu.m_38853_((int)0).f_40218_;
        if (container instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)container;
            LockCacheUtil.updateLockSnapshot(be);
        }
    }
}

