/*
 * Decompiled with CFR 0.152.
 */
package me.alini.simplelocks.util;

import java.lang.reflect.Field;
import java.util.WeakHashMap;
import me.alini.simplelocks.item.lock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class LockCacheUtil {
    private static final WeakHashMap<BlockEntity, Boolean> lockSnapshotCache = new WeakHashMap();

    public static boolean isLockItem(ItemStack stack) {
        if (!stack.m_41619_() && lock.LOCK_ITEM.isPresent() && stack.m_41720_() == lock.LOCK_ITEM.get()) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128403_("Owner");
        }
        return false;
    }

    public static boolean scanForLock(BlockEntity be) {
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (!LockCacheUtil.isLockItem(container.m_8020_(i))) continue;
                return true;
            }
        }
        boolean[] found = new boolean[]{false};
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!LockCacheUtil.isLockItem(handler.getStackInSlot(i))) continue;
                found[0] = true;
                break;
            }
        });
        if (found[0]) {
            return true;
        }
        try {
            Field[] fields;
            for (Field field : fields = be.getClass().getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0) continue;
                field.setAccessible(true);
                Object value = field.get(be);
                if (value instanceof ItemStack) {
                    ItemStack stack = (ItemStack)value;
                    if (!LockCacheUtil.isLockItem(stack)) continue;
                    return true;
                }
                if (value instanceof Iterable) {
                    Iterable list = (Iterable)value;
                    for (Object obj : list) {
                        ItemStack stack;
                        if (!(obj instanceof ItemStack) || !LockCacheUtil.isLockItem(stack = (ItemStack)obj)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(value instanceof IItemHandler)) continue;
                IItemHandler handler2 = (IItemHandler)value;
                for (int i = 0; i < handler2.getSlots(); ++i) {
                    if (!LockCacheUtil.isLockItem(handler2.getStackInSlot(i))) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasLock(BlockEntity be) {
        Boolean cached = lockSnapshotCache.get(be);
        if (cached != null) {
            return cached;
        }
        boolean found = LockCacheUtil.scanForLock(be);
        lockSnapshotCache.put(be, found);
        return found;
    }

    public static void updateLockSnapshot(BlockEntity be) {
        boolean found = LockCacheUtil.scanForLock(be);
        lockSnapshotCache.put(be, found);
    }

    public static void removeLockSnapshot(BlockEntity be) {
        lockSnapshotCache.remove(be);
    }
}

