/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.wwee.config.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.wwee.config.jankson.config.CommentedConfig;
import java.util.HashMap;
import net.minecraft.Util;
import org.jetbrains.annotations.NotNull;

public record EEConfig(String mode, boolean forceLargeBiomes, boolean removeOreBlobs, boolean checkForUpdates, boolean showUpdates, boolean showBigUpdates) implements CommentedConfig<EEConfig>
{
    private static EEConfig INSTANCE = null;
    public static final EEConfig DEFAULT = new EEConfig("DEFAULT", false, true, true, true, true);
    public static final Codec<EEConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("mode").orElse((Object)"DEFAULT").forGetter(config -> config.mode), (App)Codec.BOOL.fieldOf("forceLargeBiomes").orElse((Object)false).forGetter(config -> config.forceLargeBiomes), (App)Codec.BOOL.fieldOf("removeOreBlobs").orElse((Object)true).forGetter(config -> config.removeOreBlobs), (App)Codec.BOOL.fieldOf("checkForUpdates").orElse((Object)true).forGetter(config -> config.checkForUpdates), (App)Codec.BOOL.fieldOf("showUpdates").orElse((Object)true).forGetter(config -> config.showUpdates), (App)Codec.BOOL.fieldOf("showBigUpdates").orElse((Object)true).forGetter(config -> config.showBigUpdates)).apply((Applicative)builder, EEConfig::new));

    @Override
    public String getSubPath() {
        return "expanded_ecosphere/config";
    }

    @Override
    public EEConfig getInstance() {
        return INSTANCE;
    }

    @Override
    public EEConfig getDefault() {
        return DEFAULT;
    }

    @Override
    public Codec<EEConfig> getCodec() {
        return CODEC;
    }

    @Override
    @NotNull
    public HashMap<String, String> getComments() {
        return (HashMap)Util.make(new HashMap(), map -> {
            map.put("removeOreBlobs", "Removes underground ores (andesite, diorite, granite, gravel and dirt).");
            map.put("mode", "Type DEFAULT or COMPATIBLE, for changing modes.\nCOMPATIBLE allows compat with Terralith and disabling biomes in banned_biomes.json5,\nbut it requires Terrablender and is a bit unstable.");
            map.put("checkForUpdates", "Whether WWEE should check if there are any updates.");
            map.put("showUpdates", "Whether updates should be announced in chat when entering a world.");
            map.put("forceLargeBiomes", "Whether to force Minecraft to generate Large Biomes or not.\nThis option forces Minecraft to generate Large Biomes, this setting was introduced,\nbecause the default presets do not work (correctly).\nThis option will probably not work with Compatible mode, or other biome mods.");
            map.put("showBigUpdates", "Whether to announce important updates even if the above setting is disabled.");
        });
    }

    @Override
    @NotNull
    public String getHeader() {
        return String.format("Expanded Ecosphere Main Config\n\n===========\nDiscord: %s\nModrinth: %s\nCurseForge: %s", "https://discord.com/invite/yJng7sC44x", "https://modrinth.com/mod/expanded-ecosphere", "https://www.curseforge.com/minecraft/mc-mods/expanded-ecosphere");
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public void setInstance(EEConfig instance) {
        INSTANCE = instance;
    }
}

