/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.wwee.terra;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.wwee.EERL;
import de.cristelknight.wwee.ExpandedEcosphere;
import de.cristelknight.wwee.config.configs.ReplaceBiomesConfig;
import de.cristelknight.wwee.terra.WWOORegion;
import de.cristelknight.wwee.utils.BiomeReplace;
import de.cristelknight.wwee.utils.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class TerraInit {
    private static final String OVERWORLD = "resources/ee_default/data/minecraft/dimension/overworld.json";
    private static final String NOISE = "resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json";

    public static List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> readParameterPoints() {
        ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> arrayList;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)"expanded_ecosphere", (String)OVERWORLD);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.error("Couldn't read resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement el = JsonParser.parseReader((Reader)reader);
            if (!el.isJsonObject()) {
                throw new RuntimeException("Input stream is on JsonElement");
            }
            ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> list = new ArrayList<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>();
            JsonObject o = el.getAsJsonObject();
            if (((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).enableBiomes()) {
                BiomeReplace.replaceObject(o, true);
            }
            JsonArray jsonArray = o.get("generator").getAsJsonObject().get("biome_source").getAsJsonObject().get("biomes").getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject e = jsonArray.get(i).getAsJsonObject();
                String b = e.get("biome").getAsString();
                if (b.contains("minecraft:")) continue;
                JsonObject jo = e.get("parameters").getAsJsonObject();
                Climate.ParameterPoint point = (Climate.ParameterPoint)Util.readConfig((JsonElement)jo, Climate.ParameterPoint.CODEC, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
                Pair pair = new Pair((Object)point, (Object)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)b)));
                list.add((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)pair);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                ExpandedEcosphere.LOGGER.error("Couldn't find resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
                throw new RuntimeException(e);
            }
            catch (JsonSyntaxException | IOException e) {
                ExpandedEcosphere.LOGGER.error("Couldn't parse resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static SurfaceRules.RuleSource readSurfaceRulesFromNoise() {
        SurfaceRules.RuleSource ruleSource;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)"expanded_ecosphere", (String)NOISE);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.error("Couldn't read resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement load = JsonParser.parseReader((Reader)reader);
            JsonElement element = load.getAsJsonObject().get("surface_rule");
            ruleSource = (SurfaceRules.RuleSource)Util.readConfig(element, SurfaceRules.RuleSource.CODEC, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception errorMsg) {
                throw new IllegalArgumentException("Couldn't parse resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json, crashing instead.");
            }
        }
        reader.close();
        return ruleSource;
    }

    public static void terraEnableDisable() {
        if (ExpandedEcosphere.currentMode.equals((Object)ExpandedEcosphere.Mode.COMPATIBLE)) {
            TerraInit.terraEnable();
        } else {
            Regions.remove((RegionType)RegionType.OVERWORLD, (ResourceLocation)EERL.create("overworld"));
            SurfaceRuleManager.removeSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"wythers");
        }
    }

    public static void terraEnable() {
        TerraInit.registerRegions();
        TerraInit.readOverworldSurfaceRules();
    }

    private static void registerRegions() {
        Regions.register((Region)new WWOORegion(EERL.create("overworld"), 10));
    }

    private static void readOverworldSurfaceRules() {
        SurfaceRules.RuleSource s = TerraInit.readSurfaceRulesFromNoise();
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"wythers", (SurfaceRules.RuleSource)s);
    }
}

