/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.wwee.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.util.Platform;
import de.cristelknight.wwee.EEExpectPlatform;
import de.cristelknight.wwee.ExpandedEcosphere;
import de.cristelknight.wwee.config.configs.EEConfig;
import de.cristelknight.wwee.utils.Update;
import de.cristelknight.wwee.utils.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Updater {
    private Optional<Update> info;
    private final String currentVersion;
    private boolean isBig = false;
    private int newUpdates;
    private static final String s = "[Expanded Ecosphere Updater]";

    public Updater(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void checkForUpdates() {
        EEConfig config = (EEConfig)EEConfig.DEFAULT.getConfig();
        if (!config.checkForUpdates()) {
            return;
        }
        try {
            InputStream in = URI.create("https://github.com/Cristelknight999/CristelknightUpdateChecker/releases/download/1.0/update.json").toURL().openStream();
            try {
                String updateIndex;
                try {
                    updateIndex = JsonParser.parseReader((Reader)new InputStreamReader(in)).getAsJsonObject().get(Updater.getReleaseTarget()).getAsString();
                }
                catch (NullPointerException e) {
                    ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] This version doesn't have an update index, skipping");
                    this.info = Optional.empty();
                    if (in != null) {
                        in.close();
                    }
                    return;
                }
                JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(URI.create(updateIndex).toURL().openStream())).getAsJsonObject();
                ArrayList<Update> newUpdate = new ArrayList<Update>();
                boolean isForge = CristelLibExpectPlatform.getPlatform().equals((Object)Platform.FORGE);
                for (JsonElement element : object.getAsJsonArray("versions")) {
                    Update u = (Update)new Gson().fromJson(element, Update.class);
                    if (isForge && u.modDownloadFO.isEmpty() || !isForge && u.modDownloadFA.isEmpty() || !EEExpectPlatform.isNewer(this.currentVersion, u.semanticVersion)) continue;
                    newUpdate.add(u);
                    if (!u.isBig) continue;
                    this.isBig = true;
                }
                if (newUpdate.isEmpty()) {
                    this.info = Optional.empty();
                    ExpandedEcosphere.LOGGER.info("[Expanded Ecosphere Updater] Found no updates");
                    return;
                }
                this.newUpdates = newUpdate.size();
                String isBigString = this.isBig ? " important" : "";
                ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Found an{} update!", (Object)isBigString);
                this.info = newUpdate.stream().findFirst();
                return;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Unable to download {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Failed to get update info!", (Throwable)e);
        }
        this.info = Optional.empty();
    }

    public boolean isBig() {
        return this.isBig;
    }

    public Optional<Component> getUpdateMessage() {
        Update update = this.info.orElse(null);
        if (update == null) {
            return Optional.empty();
        }
        String string = this.isBig ? "expanded_ecosphere.config.text.newUpdateBig" : "expanded_ecosphere.config.text.newUpdate";
        MutableComponent component1 = Component.translatable((String)"expanded_ecosphere.config.text.newUpdates", (Object[])new Object[]{this.newUpdates, this.newUpdates > 1 ? Util.translatableText("multiple") : Util.translatableText("null")}).withStyle(ChatFormatting.GRAY);
        boolean isForge = CristelLibExpectPlatform.getPlatform().equals((Object)Platform.FORGE);
        MutableComponent component = Component.translatable((String)string, (Object[])new Object[]{Util.translatableText("ch").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, isForge ? update.modDownloadFO : update.modDownloadFA))), component1});
        return Optional.of(component);
    }

    public static String getReleaseTarget() {
        return SharedConstants.getCurrentVersion().isStable() ? SharedConstants.getCurrentVersion().getName() : "1.21";
    }
}

