/*
 * Decompiled with CFR 0.152.
 */
package vertigo.professionalvillagers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;
import vertigo.professionalvillagers.ProfessionalVillagers;

public class Config {
    private static final String SEPARATOR = " = ";
    private static final String QUICK_REROLL = "quickReroll";
    private static final String DISMISS_TRADER = "dismissTrader";
    private static final String RESET_PROFESSION = "resetProfession";
    private static final String LEARN_ENCHANTMENT = "learnEnchantment";
    private static final String LEVEL_ENCHANTMENTS = "levelEnchantments";
    private static final String MODIFIED_TRADES = "modifiedTrades";
    public boolean quickReroll = true;
    public boolean dismissTrader = true;
    public boolean resetProfession = false;
    public boolean learnEnchantment = false;
    public boolean levelEnchantments = true;
    public boolean modifiedTrades = false;

    public Config() {
        if (!this.read()) {
            this.write();
        }
    }

    public void write() {
        File file = this.getFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("quickReroll = " + this.quickReroll + System.lineSeparator());
            writer.write("dismissTrader = " + this.dismissTrader + System.lineSeparator());
            writer.write("resetProfession = " + this.resetProfession + System.lineSeparator());
            writer.write("learnEnchantment = " + this.learnEnchantment + System.lineSeparator());
            writer.write("levelEnchantments = " + this.levelEnchantments + System.lineSeparator());
            writer.write("modifiedTrades = " + this.modifiedTrades);
        }
        catch (IOException e) {
            ProfessionalVillagers.LOGGER.error("Failed to write config ({})", (Object)file.getPath());
        }
    }

    public boolean read() {
        File file = this.getFile();
        if (!file.exists()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] segments = line.split(SEPARATOR);
                if (segments.length != 2 || segments[0].isEmpty() || segments[1].isEmpty()) continue;
                switch (segments[0]) {
                    case "quickReroll": {
                        this.quickReroll = segments[1].equals("true");
                        break;
                    }
                    case "dismissTrader": {
                        this.dismissTrader = segments[1].equals("true");
                        break;
                    }
                    case "resetProfession": {
                        this.resetProfession = segments[1].equals("true");
                        break;
                    }
                    case "learnEnchantment": {
                        this.learnEnchantment = segments[1].equals("true");
                        break;
                    }
                    case "levelEnchantments": {
                        this.levelEnchantments = segments[1].equals("true");
                        break;
                    }
                    case "modifiedTrades": {
                        this.modifiedTrades = segments[1].equals("true");
                    }
                }
            }
        }
        catch (IOException e) {
            ProfessionalVillagers.LOGGER.error("Failed to read config ({})", (Object)file.getPath());
        }
        return true;
    }

    private File getFile() {
        return FabricLoader.getInstance().getGameDir().resolve("config").resolve("professional-villagers.ini").toFile();
    }
}

