/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import link.star_dust.MinerTrack.Notifier;
import link.star_dust.MinerTrack.commands.MinerTrackCommand;
import link.star_dust.MinerTrack.listeners.LogCacheListener;
import link.star_dust.MinerTrack.listeners.MiningDetectionExtension;
import link.star_dust.MinerTrack.listeners.MiningListener;
import link.star_dust.MinerTrack.managers.ConfigManager;
import link.star_dust.MinerTrack.managers.LanguageManager;
import link.star_dust.MinerTrack.managers.UpdateManager;
import link.star_dust.MinerTrack.managers.ViolationManager;
import link.star_dust.bstats.bukkit.Metrics;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MinerTrack
extends JavaPlugin
implements Listener {
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private ViolationManager violationManager;
    private Notifier notifier;
    private final Set<UUID> verbosePlayers = new HashSet<UUID>();
    private boolean verboseConsole = false;
    private UpdateManager updateManager;
    private String ColoredVersion;
    public MiningDetectionExtension miningDetectionExtension;
    private MinerTrackCommand minerTrackCommand;
    private MiningListener miningListener;

    public void onEnable() {
        boolean isHasNewerVersion;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.violationManager = new ViolationManager(this);
        this.notifier = new Notifier(this);
        this.updateManager = new UpdateManager(this);
        int pluginId = 23790;
        new Metrics(this, pluginId);
        this.registerCommands();
        this.registerListeners();
        this.getCommand("minertrack").setExecutor((CommandExecutor)new MinerTrackCommand(this));
        this.ColoredVersion = this.getConfigManager().updateCheck() ? ((isHasNewerVersion = this.updateManager.isHasNewerVersion()) ? "&cv" + this.getDescription().getVersion() : "&av" + this.getDescription().getVersion()) : "&av" + this.getDescription().getVersion();
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&8----[&9&lMiner&c&lTrack " + this.ColoredVersion + " &8]-----------"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&9&lMiner&c&lTrack &4&oAnti-XRay &aEnabled!"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors(""));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Authors: Author87668"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Original Author: Author87668"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Contributors: Author87668, Zhang12334"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors(""));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&a&oThanks for your use!"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&8-----------------------------------------"));
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        if (!this.getConfigManager().updateCheck()) {
            return;
        }
        this.getLogger().info("Server has finished loading. Checking for updates...");
        this.checkForUpdates(null);
    }

    public String applyColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void registerCommands() {
        this.minerTrackCommand = new MinerTrackCommand(this);
        this.getCommand("mtrack").setExecutor((CommandExecutor)this.minerTrackCommand);
        this.getCommand("mtrack").setTabCompleter((TabCompleter)this.minerTrackCommand);
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.miningListener = new MiningListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.miningListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new LogCacheListener(this.minerTrackCommand), (Plugin)this);
    }

    public MiningListener getMiningListener() {
        return this.miningListener;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public ViolationManager getViolationManager() {
        return this.violationManager;
    }

    public Set<UUID> getVerbosePlayers() {
        return this.verbosePlayers;
    }

    public boolean isVerboseConsoleEnabled() {
        return this.verboseConsole;
    }

    public void toggleVerboseMode(CommandSender sender) {
        String enableMessage = this.getLanguageManager().getPrefixedMessage("verbose-enable");
        String disableMessage = this.getLanguageManager().getPrefixedMessage("verbose-disable");
        if (sender instanceof Player) {
            Player player = (Player)sender;
            UUID playerId = player.getUniqueId();
            if (this.verbosePlayers.contains(playerId)) {
                this.verbosePlayers.remove(playerId);
                player.sendMessage(disableMessage);
            } else {
                this.verbosePlayers.add(playerId);
                player.sendMessage(enableMessage);
            }
        } else if (sender instanceof ConsoleCommandSender) {
            boolean bl = this.verboseConsole = !this.verboseConsole;
            if (this.verboseConsole) {
                sender.sendMessage(enableMessage);
            } else {
                sender.sendMessage(disableMessage);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        BaseComponent[] updateComponent;
        if (!this.configManager.updateCheck()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("minertrack.checkupdate") && this.updateManager.isHasNewerVersion() && (updateComponent = this.updateManager.getUpdateMessageComponent()) != null) {
            player.spigot().sendMessage(updateComponent);
        }
    }

    public void checkForUpdates(CommandSender sender) {
        this.updateManager.checkForUpdates(sender);
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&8----[&9&lMiner&c&lTrack " + this.ColoredVersion + " &8]-----------"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&9&lMiner&c&lTrack &4&oAnti-XRay &cDisabled!"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors(""));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Authors: Author87668"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Original Author: Author87668"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&7Contributors: Author87668, Zhang12334"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors(""));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&a&oGood bye!"));
        this.getServer().getConsoleSender().sendMessage(this.applyColors("&8-----------------------------------------"));
    }
}

