/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import link.star_dust.MinerTrack.FoliaCheck;
import link.star_dust.MinerTrack.MinerTrack;
import link.star_dust.MinerTrack.utils.LogViewerUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MinerTrackCommand
implements CommandExecutor,
TabCompleter {
    private final MinerTrack plugin;

    public MinerTrackCommand(MinerTrack plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !(sender instanceof ConsoleCommandSender) && !sender.hasPermission("minertrack.use")) {
            sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            if (!sender.hasPermission("minertrack.help")) {
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                return true;
            }
            List<String> helpMessages = this.plugin.getLanguageManager().getHelpMessages();
            for (String message : helpMessages) {
                sender.sendMessage(this.plugin.getLanguageManager().applyColors(message));
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "notify": {
                if (!sender.hasPermission("minertrack.sendnotify")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-notify"));
                    return true;
                }
                String messageContent = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                this.plugin.getNotifier().sendNotifyMessage(messageContent);
                break;
            }
            case "verbose": {
                if (!sender.hasPermission("minertrack.verbose")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                this.plugin.toggleVerboseMode(sender);
                break;
            }
            case "check": {
                if (!sender.hasPermission("minertrack.check")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-check"));
                    return true;
                }
                Player target = this.plugin.getServer().getPlayer(args[1]);
                if (target != null) {
                    int violationLevel = this.plugin.getViolationManager().getViolationLevel(target);
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("violation-level").replace("{player}", target.getName()).replace("{level}", String.valueOf(violationLevel)));
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("player-not-found").replace("{player}", args[1]));
                break;
            }
            case "reset": {
                if (!sender.hasPermission("minertrack.reset")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-reset"));
                    return true;
                }
                Player targetToReset = this.plugin.getServer().getPlayer(args[1]);
                if (targetToReset != null) {
                    this.plugin.getViolationManager().resetViolationLevel(targetToReset);
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("reset-success").replace("{player}", args[1]));
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("player-not-found").replace("{player}", args[1]));
                break;
            }
            case "kick": {
                if (!sender.hasPermission("minertrack.kick")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-kick"));
                    return true;
                }
                Player playerToKick = this.plugin.getServer().getPlayer(args[1]);
                if (playerToKick != null) {
                    String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                    if (this.plugin.getConfigManager().isKickStrikeLightning()) {
                        if (FoliaCheck.isFolia()) {
                            Bukkit.getRegionScheduler().execute((Plugin)this.plugin, playerToKick.getLocation(), () -> {
                                try {
                                    playerToKick.getWorld().strikeLightningEffect(playerToKick.getLocation());
                                }
                                catch (Exception e) {
                                    this.plugin.getLogger().severe("Failed to strike lightning effect on Folia: " + e.getMessage());
                                    e.printStackTrace();
                                }
                            });
                        } else {
                            try {
                                playerToKick.getWorld().strikeLightningEffect(playerToKick.getLocation());
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Failed to strike lightning effect: " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.plugin.getLanguageManager().isKickBroadcastEnabled()) {
                        String kickMessage = this.plugin.getLanguageManager().getPrefixedMessage("kick-format").replace("%player%", playerToKick.getName()).replace("%reason%", reason);
                        this.plugin.getServer().broadcastMessage(kickMessage);
                    }
                    this.plugin.getNotifier().kickPlayer(playerToKick, reason);
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("player-not-found").replace("{player}", args[1]));
                break;
            }
            case "reload": {
                if (!sender.hasPermission("minertrack.reload")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getLanguageManager().loadLanguageFile();
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("config-reloaded"));
                break;
            }
            case "update": {
                if (!sender.hasPermission("minertrack.checkupdate")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                this.plugin.checkForUpdates(sender);
                break;
            }
            case "logs": {
                if (!sender.hasPermission("minertrack.logs")) {
                    sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("no-permission"));
                    return true;
                }
                if (args.length == 2) {
                    String logName = args[1];
                    if (!logName.endsWith(".log")) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-not-log-file"));
                        return true;
                    }
                    File logDir = new File(this.plugin.getDataFolder(), "logs");
                    File logFile = new File(logDir, logName);
                    if (!logFile.exists() || !logFile.isFile()) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-not-found").replace("{log_file}", logName));
                        return true;
                    }
                    try {
                        List<String> lines = LogViewerUtils.readLogFile(logFile);
                        ArrayList<String> reversedLines = new ArrayList<String>(lines);
                        Collections.reverse(reversedLines);
                        int perPage = this.plugin.getLanguageManager().getLogViewerLinesPerPage();
                        int totalPages = LogViewerUtils.getTotalPages(reversedLines.size(), perPage);
                        int page = 1;
                        LogViewerUtils.LogCache cache = new LogViewerUtils.LogCache(logName, reversedLines, totalPages, page);
                        LogViewerUtils.putCache(sender, cache);
                        this.sendLogPage(sender, cache, perPage);
                    }
                    catch (IOException e) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-cant-read"));
                    }
                    return true;
                }
                if (args.length == 3 && args[1].equalsIgnoreCase("page")) {
                    int page;
                    LogViewerUtils.LogCache cache = LogViewerUtils.getCache(sender);
                    if (cache == null) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-logs"));
                        return true;
                    }
                    try {
                        page = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException ex) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-page-nan"));
                        return true;
                    }
                    if (page < 1 || page > cache.totalPages) {
                        sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-page-invalid").replace("{max_page}", String.valueOf(cache.totalPages)));
                        return true;
                    }
                    cache.currentPage = page;
                    this.sendLogPage(sender, cache, this.plugin.getLanguageManager().getLogViewerLinesPerPage());
                    return true;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("usage-logs"));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("unknown-command"));
            }
        }
        return true;
    }

    private void sendLogPage(CommandSender sender, LogViewerUtils.LogCache cache, int perPage) {
        int totalLines = cache.lines.size();
        int page = cache.currentPage;
        int totalPages = cache.totalPages;
        int[] range = LogViewerUtils.getPageRange(totalLines, page, perPage);
        int start = range[0];
        int end = range[1];
        String header = this.plugin.getLanguageManager().getColoredMessage("log-viewer-header").replace("{current_page}", String.valueOf(page)).replace("{max_page}", String.valueOf(totalPages)).replace("{log_file}", cache.logName);
        sender.sendMessage(header);
        if (start >= end) {
            sender.sendMessage(this.plugin.getLanguageManager().getPrefixedMessage("log-viewer-empty"));
            return;
        }
        for (int i = start; i < end; ++i) {
            sender.sendMessage(this.plugin.getLanguageManager().getColoredMessage("log-viewer-logs-color") + cache.lines.get(i));
        }
        if (page < totalPages) {
            sender.sendMessage("");
            sender.sendMessage(this.plugin.getLanguageManager().getColoredMessage("log-viewer-next-page").replace("{next_page}", String.valueOf(page + 1)));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block3: {
            File logDir;
            File[] files;
            block4: {
                block2: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block2;
                    completions.addAll(Arrays.asList("help", "notify", "verbose", "check", "reset", "kick", "reload", "update", "logs"));
                    break block3;
                }
                if (args.length != 2) break block3;
                if (!args[0].equalsIgnoreCase("check") && !args[0].equalsIgnoreCase("reset") && !args[0].equalsIgnoreCase("kick")) break block4;
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    completions.add(player.getName());
                }
                break block3;
            }
            if (!args[0].equalsIgnoreCase("logs") || (files = (logDir = new File(this.plugin.getDataFolder(), "logs")).listFiles((dir, name) -> name.endsWith(".log"))) == null) break block3;
            Arrays.sort(files, Comparator.comparing(File::getName).reversed());
            int max = Math.min(10, files.length);
            for (int i = 0; i < max; ++i) {
                completions.add(files[i].getName());
            }
        }
        return completions;
    }

    public void clearLogCache(CommandSender sender) {
        LogViewerUtils.clearCache(sender);
    }
}

