/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.hooks;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import link.star_dust.MinerTrack.MinerTrack;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class CustomJsonWebHook {
    private final MinerTrack plugin;
    private final String webHookUrl;
    private final String jsonFormat;

    public CustomJsonWebHook(MinerTrack plugin, String webHookUrl, String jsonFormat) {
        this.plugin = plugin;
        this.webHookUrl = webHookUrl;
        this.jsonFormat = jsonFormat;
    }

    public void sendMessage(Map<String, String> placeholders) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost post = new HttpPost(this.webHookUrl);
                post.setHeader("Content-Type", "application/json; charset=UTF-8");
                placeholders.put("timestamp", LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
                String jsonPayload = this.jsonFormat;
                for (Map.Entry entry : placeholders.entrySet()) {
                    jsonPayload = jsonPayload.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
                }
                post.setEntity(new StringEntity(jsonPayload, StandardCharsets.UTF_8));
                try (CloseableHttpResponse response = httpClient.execute(post);){
                    int statusCode = response.getCode();
                    if (statusCode != 200 && statusCode != 204) {
                        this.plugin.getLogger().warning("Failed to send custom JSON webhook, Response Code: " + statusCode);
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error while sending custom JSON webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }
}

