/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.hooks;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import link.star_dust.MinerTrack.FoliaCheck;
import link.star_dust.MinerTrack.MinerTrack;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DiscordWebHook {
    private final MinerTrack plugin;
    private final String webHookUrl;
    private final Gson gson = new Gson();

    public DiscordWebHook(MinerTrack plugin, String webHookUrl) {
        this.plugin = plugin;
        this.webHookUrl = webHookUrl;
    }

    public void sendMessage(String content) {
        this.send(new Payload(content));
    }

    public void sendEmbed(Embed embed) {
        this.send(new Payload(embed));
    }

    private void send(Payload payload) {
        Runnable task = () -> {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost post = new HttpPost(this.webHookUrl);
                post.setHeader("Content-Type", "application/json; charset=UTF-8");
                String jsonPayload = this.gson.toJson((Object)payload);
                StringEntity entity = new StringEntity(jsonPayload, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8));
                post.setEntity(entity);
                try (CloseableHttpResponse response = httpClient.execute(post);){
                    int statusCode = response.getCode();
                    if (statusCode != 200 && statusCode != 204) {
                        this.plugin.getLogger().warning("Failed to send message to Discord WebHook. Response Code: " + statusCode);
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error while sending message to Discord WebHook: " + e.getMessage());
                e.printStackTrace();
            }
        };
        if (FoliaCheck.isFolia()) {
            Thread t = new Thread(task, "MinerTrack-DiscordWebHook");
            t.setDaemon(true);
            t.start();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }

    public static class Payload {
        @SerializedName(value="content")
        private final String content;
        @SerializedName(value="embeds")
        private final Embed[] embeds;

        public Payload(String content) {
            this.content = content;
            this.embeds = null;
        }

        public Payload(Embed embed) {
            this.content = null;
            this.embeds = new Embed[]{embed};
        }
    }

    public static class Embed {
        @SerializedName(value="title")
        private final String title;
        @SerializedName(value="description")
        private final String description;
        @SerializedName(value="color")
        private final int color;

        public Embed(String title, String description, int color) {
            this.title = title;
            this.description = description;
            this.color = color;
        }
    }
}

