/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.managers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import link.star_dust.MinerTrack.MinerTrack;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final MinerTrack plugin;
    private final File configFile;
    private final FileConfiguration config;

    public ConfigManager(MinerTrack plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        try (InputStream defaultStream = plugin.getResource("config.yml");){
            if (defaultStream != null) {
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
                this.mergeConfigurations((ConfigurationSection)this.config, (ConfigurationSection)defaultConfig, "");
                this.saveConfig();
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error loading default configuration: " + e.getMessage());
        }
    }

    private void mergeConfigurations(ConfigurationSection currentConfig, ConfigurationSection defaultConfig, String currentPath) {
        Set<String> whitelistKeys = Set.of("check_update", "check_update_channel", "kick_strike_lightning", "log_file", "delete_time", "disable_bypass_permission", "DiscordWebHook", "DiscordWebHook.enable", "DiscordWebHook.WebHookURL", "DiscordWebHook.vl-required", "DiscordWebHook.vl-add-message", "DiscordWebHook.vl-add-message.color", "DiscordWebHook.vl-add-message.title", "DiscordWebHook.vl-add-message.text", "xray", "xray.enable", "xray.worlds", "xray.worlds.world", "xray.worlds.all_unnamed_world", "xray.worlds.all_unnamed_world.enable", "xray.rare-ores", "xray.max_path_length", "xray.trace_remove", "xray.max_vein_distance", "xray.veinCountThreshold", "xray.path-detection", "xray.path-detection.turn-count-threshold", "xray.path-detection.branch-count-threshold", "xray.path-detection.y-change-threshold", "xray.path-detection.y-change-threshold-add-required", "xray.natural-detection", "xray.natural-detection.enable", "xray.natural-detection.cave", "xray.natural-detection.cave.air-threshold", "xray.natural-detection.cave.CaveAirMultiplier", "xray.natural-detection.cave.detection-range", "xray.natural-detection.cave.check_skip_vl", "xray.natural-detection.cave.air-monitor", "xray.natural-detection.cave.air-monitor.enable", "xray.natural-detection.cave.air-monitor.min-path-length", "xray.natural-detection.cave.air-monitor.air-ratio-threshold", "xray.natural-detection.cave.air-monitor.violation-increase", "xray.natural-detection.cave.air-monitor.violation-threshold", "xray.natural-detection.cave.air-monitor.remove-time", "xray.natural-detection.sea", "xray.natural-detection.sea.check-running-water", "xray.natural-detection.sea.water-threshold", "xray.natural-detection.sea.detection-range", "xray.natural-detection.sea.check_skip_vl", "xray.natural-detection.lava-sea", "xray.natural-detection.lava-sea.lava-threshold", "xray.natural-detection.lava-sea.detection-range", "xray.natural-detection.lava-sea.check_skip_vl", "xray.small_vein_detection_size", "xray.decay", "xray.decay.interval", "xray.decay.amount", "xray.decay.use_factor", "xray.decay.factor", "explosion", "explosion.entity-explode-check", "explosion.explosion_retention_time", "explosion.base_vl_rate", "explosion.suspicious_hit_rate", "commands");
        for (String key : defaultConfig.getKeys(false)) {
            String fullKeyPath = (String)(currentPath.isEmpty() ? "" : currentPath + ".") + key;
            if (!whitelistKeys.contains(fullKeyPath)) continue;
            if (currentConfig.contains(key)) {
                Object currentValue = currentConfig.get(key);
                Object defaultValue = defaultConfig.get(key);
                if (!(currentValue instanceof ConfigurationSection) || !(defaultValue instanceof ConfigurationSection)) continue;
                this.mergeConfigurations((ConfigurationSection)currentValue, (ConfigurationSection)defaultValue, fullKeyPath);
                continue;
            }
            currentConfig.set(key, defaultConfig.get(key));
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save configuration to " + this.configFile.getName() + ": " + e.getMessage());
        }
    }

    public void reloadConfig() {
        try {
            this.config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
    }

    public boolean isDenyBypassPermissionEnabled() {
        return this.config.getBoolean("disable_bypass_permission", false);
    }

    public boolean isKickStrikeLightning() {
        return this.config.getBoolean("xray.kick-strike-lightning", true);
    }

    public List<String> getRareOres() {
        return this.config.getStringList("xray.rare-ores");
    }

    public int getVeinCountThreshold() {
        return this.config.getInt("xray.veinCountThreshold", 3);
    }

    public int getTurnCountThreshold() {
        return this.config.getInt("xray.path-detection.turn-count-threshold", 10);
    }

    public int getBranchCountThreshold() {
        return this.config.getInt("xray.path-detection.branch-count-threshold", 6);
    }

    public int getYChangeThreshold() {
        return this.config.getInt("xray.path-detection.y-change-threshold", 4);
    }

    public int getWorldMaxHeight(String worldName) {
        ConfigurationSection xraySection = this.config.getConfigurationSection("xray.worlds");
        if (xraySection == null || !xraySection.isConfigurationSection(worldName)) {
            return this.config.getInt("xray.worlds.all_unnamed_world.max-height", -1);
        }
        return xraySection.getInt(worldName + ".max-height", -1);
    }

    public boolean isWorldDetectionEnabled(String worldName) {
        ConfigurationSection worldsSection = this.config.getConfigurationSection("xray.worlds");
        if (worldsSection == null || !worldsSection.isConfigurationSection(worldName)) {
            return this.config.getBoolean("xray.worlds.all_unnamed_world.enable", false);
        }
        return worldsSection.getBoolean(worldName + ".enable", false);
    }

    public boolean DisableBypass() {
        return this.config.getBoolean("disable_bypass_permission", false);
    }

    public String getCommandForThreshold(int threshold) {
        ConfigurationSection commandsSection = this.config.getConfigurationSection("xray.commands");
        if (commandsSection != null && commandsSection.contains(String.valueOf(threshold))) {
            return commandsSection.getString(String.valueOf(threshold));
        }
        return null;
    }

    public int getMaxVeinDistance() {
        return this.config.getInt("xray.max_vein_distance", 5);
    }

    public int getSmallVeinSize() {
        return this.config.getInt("xray.small_vein_detection_size", 4);
    }

    public boolean getNaturalEnable() {
        return this.config.getBoolean("xray.natural-detection.enable", true);
    }

    public int getCaveBypassAirThreshold() {
        return this.config.getInt("xray.natural-detection.cave.air-threshold", 14);
    }

    public int getCaveAirMultiplier() {
        return this.config.getInt("xray.natural-detection.cave.CaveAirMultiplier", 5);
    }

    public int getCaveDetectionRange() {
        return this.config.getInt("xray.natural-detection.cave.detection-range", 3);
    }

    public boolean isCaveSkipVL() {
        return this.config.getBoolean("xray.natural-detection.cave.check_skip_vl", true);
    }

    public boolean isRunningWaterCheckEnabled() {
        return this.config.getBoolean("xray.natural-detection.sea.check-running-water", false);
    }

    public int getWaterThreshold() {
        return this.config.getInt("xray.natural-detection.sea.water-threshold", 14);
    }

    public int getWaterDetectionRange() {
        return this.config.getInt("xray.natural-detection.sea.detection-range", 3);
    }

    public boolean isSeaSkipVL() {
        return this.config.getBoolean("xray.natural-detection.sea.check_skip_vl", true);
    }

    public int getLavaThreshold() {
        return this.config.getInt("xray.natural-detection.lava-sea.lava-threshold", 14);
    }

    public int getLavaDetectionRange() {
        return this.config.getInt("xray.natural-detection.lava-sea.detection-range", 3);
    }

    public boolean isLavaSeaSkipVL() {
        return this.config.getBoolean("xray.natural-detection.lava-sea.check_skip_vl", true);
    }

    public int traceBackLength() {
        return this.config.getInt("xray.trace_back_length", 10);
    }

    public boolean updateCheck() {
        return this.config.getBoolean("check_update", true);
    }

    public String updateCheckChannel() {
        return this.config.getString("check_update_channel", "stable");
    }

    public int getSuspicionThreshold() {
        return this.config.getInt("xray.mine.suspicionThreshold", 100);
    }

    public String WebHookURL() {
        return this.config.getString("DiscordWebHook.WebHookURL");
    }

    public boolean WebHookEnable() {
        return this.config.getBoolean("DiscordWebHook.enable", false);
    }

    public int WebHookColor() {
        return this.config.getInt("DiscordWebHook.vl-add-message.color", 16734003);
    }

    public String WebHookTitle() {
        return this.config.getString("DiscordWebHook.vl-add-message.title");
    }

    public List<String> WebHookText() {
        return this.config.getStringList("DiscordWebHook.vl-add-message.text");
    }

    public int WebHookVLRequired() {
        return this.config.getInt("DiscordWebHook.vl-required");
    }

    public boolean isCustomJsonEnabled() {
        return this.config.getBoolean("DiscordWebHook.custom-json.enable", false);
    }

    public String getCustomJsonFormat() {
        return this.config.getString("DiscordWebHook.custom-json.format", "");
    }

    public int getYPosChangeThresholdAddRequired() {
        return this.config.getInt("xray.path-detection.y-change-threshold-add-required", 3);
    }

    public int AirMonitorVLT() {
        return this.plugin.getConfig().getInt("xray.natural-detection.cave.air-monitor.violation-threshold", 5);
    }
}

