/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.managers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import link.star_dust.MinerTrack.MinerTrack;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateManager {
    private final MinerTrack plugin;
    private String latestVersion;
    private final String currentVersion;
    private String downloadUrl;

    public UpdateManager(MinerTrack plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        if (plugin.getConfigManager().updateCheck()) {
            this.fetchLatestVersionFromModrinth();
        } else {
            this.latestVersion = null;
        }
    }

    public void checkForUpdates(CommandSender sender) {
        this.fetchLatestVersionFromModrinth();
        if (this.latestVersion == null) {
            String errorMessage = this.plugin.getLanguageManager().getPrefixedMessageWithDefault("update.check-failed", "&cFailed to check for updates.");
            this.sendMessage(sender, errorMessage);
            return;
        }
        if (this.shouldConsiderAsUpdate(this.latestVersion, this.currentVersion)) {
            this.sendUpdateMessage(sender, this.latestVersion);
        } else {
            String upToDateMessage = this.plugin.getLanguageManager().getPrefixedMessageWithDefault("update.using-latest", "&2You are using the latest version.");
            this.sendMessage(sender, upToDateMessage);
        }
    }

    private void fetchLatestVersionFromModrinth() {
        try {
            String line;
            URL url = new URL("https://api.modrinth.com/v2/project/minertrack/version");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "MinerTrack Update Checker");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            JSONArray versions = new JSONArray(response.toString());
            if (versions.length() > 0) {
                JSONObject latest = versions.getJSONObject(0);
                this.latestVersion = latest.getString("version_number");
                this.downloadUrl = "https://modrinth.com/plugin/minertrack/version/" + this.latestVersion;
            } else {
                this.plugin.getLogger().warning("No versions found on Modrinth.");
                this.latestVersion = null;
                this.downloadUrl = null;
            }
        }
        catch (IOException | JSONException e) {
            this.plugin.getLogger().warning("Failed to check for updates from Modrinth: " + e.getMessage());
            this.latestVersion = null;
            this.downloadUrl = null;
        }
    }

    private boolean shouldConsiderAsUpdate(String latestVersion, String currentVersion) {
        if (latestVersion == null || currentVersion == null) {
            return false;
        }
        String channel = this.plugin.getConfigManager().updateCheckChannel().toLowerCase();
        Version latest = this.parseVersion(latestVersion);
        Version current = this.parseVersion(currentVersion);
        int mainCompare = this.compareVersionNumbers(latest.mainParts, current.mainParts);
        if (mainCompare < 0) {
            return false;
        }
        if (mainCompare > 0) {
            return this.isVersionAllowedByChannel(latest, channel);
        }
        if (latest.preReleaseTag == null && current.preReleaseTag == null) {
            return false;
        }
        if (latest.preReleaseTag == null && current.preReleaseTag != null) {
            return this.isVersionAllowedByChannel(latest, channel);
        }
        if (latest.preReleaseTag != null && latest.isNewerPreReleaseThan(current)) {
            return this.isVersionAllowedByChannel(latest, channel);
        }
        return false;
    }

    private boolean isVersionAllowedByChannel(Version version, String channel) {
        if (version.preReleaseTag == null) {
            return true;
        }
        String tag = version.preReleaseTag.toLowerCase();
        if ("alpha".equals(channel)) {
            return true;
        }
        if ("beta".equals(channel)) {
            return tag.startsWith("beta");
        }
        return false;
    }

    private Version parseVersion(String versionStr) {
        versionStr = versionStr.replaceFirst("^v", "");
        String[] parts = versionStr.split("-", 2);
        String main = parts[0];
        String pre = parts.length > 1 ? parts[1] : null;
        String[] mainSplit = main.split("\\.");
        int[] mainParts = new int[mainSplit.length];
        for (int i = 0; i < mainSplit.length; ++i) {
            mainParts[i] = UpdateManager.parsePositiveInt(mainSplit[i], 0);
        }
        return new Version(mainParts, pre);
    }

    private int compareVersionNumbers(int[] a, int[] b) {
        int len = Math.max(a.length, b.length);
        for (int i = 0; i < len; ++i) {
            int vb;
            int va = i < a.length ? a[i] : 0;
            int n = vb = i < b.length ? b[i] : 0;
            if (va == vb) continue;
            return Integer.compare(va, vb);
        }
        return 0;
    }

    private static int comparePreRelease(String a, String b) {
        int numB;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        String aLower = a.toLowerCase();
        String bLower = b.toLowerCase();
        boolean aIsAlpha = aLower.startsWith("alpha");
        boolean aIsBeta = aLower.startsWith("beta");
        boolean bIsAlpha = bLower.startsWith("alpha");
        boolean bIsBeta = bLower.startsWith("beta");
        if (aIsBeta && bIsAlpha) {
            return 1;
        }
        if (aIsAlpha && bIsBeta) {
            return -1;
        }
        if ((aIsBeta || aIsAlpha) != (bIsBeta || bIsAlpha)) {
            return a.compareTo(b);
        }
        int numA = UpdateManager.extractNumericSuffix(a);
        if (numA != (numB = UpdateManager.extractNumericSuffix(b))) {
            return Integer.compare(numA, numB);
        }
        return a.compareTo(b);
    }

    private static int extractNumericSuffix(String tag) {
        String[] parts = tag.split("[^0-9]+");
        for (int i = parts.length - 1; i >= 0; --i) {
            if (parts[i].isEmpty()) continue;
            try {
                return Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static int parsePositiveInt(String str, int defaultValue) {
        try {
            int val = Integer.parseInt(str.trim());
            return val >= 0 ? val : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean isHasNewerVersion() {
        return this.latestVersion != null && this.shouldConsiderAsUpdate(this.latestVersion, this.currentVersion);
    }

    public BaseComponent[] getUpdateMessageComponent() {
        if (this.latestVersion == null || !this.shouldConsiderAsUpdate(this.latestVersion, this.currentVersion)) {
            return null;
        }
        String messageKey = this.latestVersion.contains("-beta") ? "update.beta-available" : (this.latestVersion.contains("-alpha") ? "update.alpha-available" : "update.stable-available");
        String defaultMessage = this.latestVersion.contains("-beta") ? "&eNew beta version %latest_version% now available!" : (this.latestVersion.contains("-alpha") ? "&cNew alpha version %latest_version% now available!" : "&aNew stable version %latest_version% now available!");
        String baseMessage = this.plugin.getLanguageManager().getPrefixedMessageWithDefault(messageKey, defaultMessage).replace("%latest_version%", this.latestVersion);
        TextComponent component = new TextComponent(this.plugin.getLanguageManager().applyColors(baseMessage));
        if (this.downloadUrl != null) {
            component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadUrl));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.plugin.getLanguageManager().applyColors("&f" + this.latestVersion + ": " + this.downloadUrl))}));
        }
        return new BaseComponent[]{component};
    }

    private void sendMessage(CommandSender sender, String message) {
        String coloredMessage = this.plugin.getLanguageManager().applyColors(message);
        if (sender != null) {
            sender.sendMessage(coloredMessage);
        } else {
            Bukkit.getConsoleSender().sendMessage(coloredMessage);
        }
    }

    private void sendUpdateMessage(CommandSender sender, String latestVersion) {
        String messageKey = latestVersion.contains("-beta") ? "update.beta-available" : (latestVersion.contains("-alpha") ? "update.alpha-available" : "update.stable-available");
        String defaultMessage = latestVersion.contains("-beta") ? "&eNew beta version %latest_version% now available!" : (latestVersion.contains("-alpha") ? "&cNew alpha version %latest_version% now available!" : "&aNew stable version %latest_version% now available!");
        String baseMessage = this.plugin.getLanguageManager().getPrefixedMessageWithDefault(messageKey, defaultMessage).replace("%latest_version%", latestVersion);
        TextComponent component = new TextComponent(this.plugin.getLanguageManager().applyColors(baseMessage));
        if (this.downloadUrl != null) {
            component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadUrl));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent(this.plugin.getLanguageManager().applyColors("&f" + latestVersion + ": " + this.downloadUrl))}));
        }
        if (sender instanceof Player) {
            ((Player)sender).spigot().sendMessage((BaseComponent)component);
        } else {
            Bukkit.getConsoleSender().sendMessage(this.plugin.getLanguageManager().applyColors(baseMessage));
        }
    }

    private static class Version {
        final int[] mainParts;
        final String preReleaseTag;

        Version(int[] mainParts, String preReleaseTag) {
            this.mainParts = mainParts;
            this.preReleaseTag = preReleaseTag;
        }

        boolean isNewerPreReleaseThan(Version other) {
            boolean otherStable;
            boolean thisStable = this.preReleaseTag == null;
            boolean bl = otherStable = other.preReleaseTag == null;
            if (thisStable && !otherStable) {
                return true;
            }
            if (!thisStable && otherStable) {
                return false;
            }
            if (thisStable && otherStable) {
                return false;
            }
            return UpdateManager.comparePreRelease(this.preReleaseTag, other.preReleaseTag) > 0;
        }
    }
}

