/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.MinerTrack.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import link.star_dust.MinerTrack.MinerTrack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class MiningDetectionExtension
implements Listener {
    private final Map<UUID, List<MiningFeature>> miningHistory = new HashMap<UUID, List<MiningFeature>>();
    private final Map<UUID, Integer> playerSuspicionMap = new HashMap<UUID, Integer>();
    private final MinerTrack plugin;

    public MiningDetectionExtension(MinerTrack plugin) {
        this.plugin = plugin;
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        this.analyzeMiningPattern(player, block);
    }

    private void analyzeMiningPattern(Player player, Block block) {
        World world = block.getWorld();
        if (world == null) {
            return;
        }
        Location location = block.getLocation();
        int airBlocks = 0;
        int solidBlocks = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Block nearby = world.getBlockAt(location.clone().add((double)x, (double)y, (double)z));
                    if (nearby.getType() == Material.AIR && nearby.getType() == Material.CAVE_AIR) {
                        ++airBlocks;
                        continue;
                    }
                    if (!nearby.getType().isSolid()) continue;
                    ++solidBlocks;
                }
            }
        }
        UUID playerId = player.getUniqueId();
        MiningFeature currentFeature = new MiningFeature(airBlocks, solidBlocks);
        this.miningHistory.computeIfAbsent(playerId, k -> new ArrayList()).add(currentFeature);
        List<MiningFeature> history = this.miningHistory.get(playerId);
        if (history.size() > 5) {
            history.remove(0);
        }
        int totalAir = 0;
        int totalSolid = 0;
        for (MiningFeature feature : history) {
            totalAir += feature.airBlocks;
            totalSolid += feature.solidBlocks;
        }
        int averageAir = totalAir / history.size();
        int averageSolid = totalSolid / history.size();
        int suspicionLevel = this.playerSuspicionMap.getOrDefault(playerId, 0);
        suspicionLevel = averageSolid >= 7 && averageAir <= 1 ? (suspicionLevel += 5) : (averageAir >= 6 ? (suspicionLevel -= 5) : ++suspicionLevel);
        this.playerSuspicionMap.put(playerId, suspicionLevel);
        this.plugin.getLogger().info(player.getName() + " -> Air: " + averageAir + ", Solid: " + averageSolid + ", Suspicion: " + suspicionLevel);
    }

    public int getSuspicionLevel(UUID playerId) {
        return this.playerSuspicionMap.getOrDefault(playerId, 0);
    }

    public int getSuspicionLevel(Player player) {
        UUID playerID = Bukkit.getOfflinePlayer((String)player.getName()).getUniqueId();
        return this.getSuspicionLevel(playerID);
    }

    public void resetSuspicionLevel(Player player) {
        UUID playerID = Bukkit.getOfflinePlayer((String)player.getName()).getUniqueId();
        this.playerSuspicionMap.put(playerID, 0);
    }

    private static class MiningFeature {
        int airBlocks;
        int solidBlocks;

        MiningFeature(int airBlocks, int solidBlocks) {
            this.airBlocks = airBlocks;
            this.solidBlocks = solidBlocks;
        }
    }
}

